/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.ext.websocket;

import cn.wizzer.app.web.commons.ext.websocket.WkNotifyService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.mvc.websocket.handler.SimpleWsHandler;

@IocBean
public class WkWsHandler
extends SimpleWsHandler {
    private static final Log log = Logs.get();
    @Inject
    private WkNotifyService wkNotifyService;

    public void msg(NutMap req) {
        this.msg(req.getString("room"));
    }

    public void msg(String room) {
        if (!Strings.isBlank((CharSequence)room)) {
            this.wkNotifyService.getMsg(room);
        }
    }

    public void join(NutMap req) {
        this.join(req.getString("room"));
    }

    public void left(NutMap req) {
        this.left(req.getString("room"));
    }

    public void join(String room) {
        if (!Strings.isBlank((CharSequence)room)) {
            room = this.prefix + room;
            log.debugf("session(id=%s) join room(name=%s)", new Object[]{this.session.getId(), room});
            this.roomProvider.join(room, this.session.getId());
        }
    }

    public void left(String room) {
        if (!Strings.isBlank((CharSequence)room)) {
            room = this.prefix + room;
            log.debugf("session(id=%s) left room(name=%s)", new Object[]{this.session.getId(), room});
            this.roomProvider.left(room, this.session.getId());
        }
    }

    public void depose() {
    }
}

