/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.services.SysLogService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.DateUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/log"})
public class SysLogController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysLogService sysLogService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/log/index.html")
    @RequiresPermissions(value={"sys.manager.log"})
    public void index(HttpServletRequest req) {
        req.setAttribute("today", (Object)DateUtil.getDate());
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.log"})
    public Object data(@Param(value="beginDate") String beginDate, @Param(value="endDate") String endDate, @Param(value="type") String type, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        String tableName = Times.format((String)"yyyyMM", (Date)new Date());
        if (Strings.isNotBlank((CharSequence)beginDate)) {
            tableName = Times.format((String)"yyyyMM", (Date)Times.D((String)(beginDate + " 00:00:00")));
            cnd.and("opAt", ">=", (Object)DateUtil.getTime(beginDate + " 00:00:00"));
        }
        if (Strings.isNotBlank((CharSequence)endDate)) {
            cnd.and("opAt", "<=", (Object)DateUtil.getTime(endDate + " 23:59:59"));
        }
        if (Strings.isNotBlank((CharSequence)type)) {
            cnd.and("type", "=", (Object)type);
        }
        return this.sysLogService.logData(tableName, length, start, draw, order, columns, cnd, null);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.log.delete"})
    @SLog(tag="\u6e05\u9664\u65e5\u5fd7", msg="\u6e05\u9664\u65e5\u5fd7")
    public Object delete(HttpServletRequest req) {
        try {
            this.sysLogService.clear();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

