/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.shiro.filter;

import cn.wizzer.app.web.commons.shiro.token.PlatformCaptchaToken;
import cn.wizzer.app.web.commons.utils.RSAUtil;
import java.security.interfaces.RSAPrivateKey;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionFilter;
import org.nutz.mvc.View;

@IocBean(name="platformAuthc")
public class PlatformAuthenticationFilter
extends FormAuthenticationFilter
implements ActionFilter {
    private static final Log log = Logs.get();
    private String captchaParam = "platformCaptcha";

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    protected AuthenticationToken createToken(HttpServletRequest request) {
        String username = this.getUsername((ServletRequest)request);
        String password = this.getPassword((ServletRequest)request);
        String captcha = this.getCaptcha((ServletRequest)request);
        boolean rememberMe = this.isRememberMe((ServletRequest)request);
        String host = this.getHost((ServletRequest)request);
        try {
            RSAPrivateKey platformPrivateKey = (RSAPrivateKey)request.getSession().getAttribute("platformPrivateKey");
            if (platformPrivateKey == null) {
                return null;
            }
            password = RSAUtil.decryptByPrivateKey(password, platformPrivateKey);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new PlatformCaptchaToken(username, password, rememberMe, host, captcha);
    }

    public View match(ActionContext actionContext) {
        HttpServletRequest request = actionContext.getRequest();
        AuthenticationToken authenticationToken = this.createToken(request);
        request.setAttribute("platformLoginToken", (Object)authenticationToken);
        return null;
    }
}

