/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.models.Sys_role;
import cn.wizzer.app.sys.modules.models.Sys_unit;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.sys.modules.services.SysMenuService;
import cn.wizzer.app.sys.modules.services.SysRoleService;
import cn.wizzer.app.sys.modules.services.SysUnitService;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.ShiroUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/role"})
public class SysRoleController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysUserService sysUserService;
    @Inject
    @Reference
    private SysMenuService sysMenuService;
    @Inject
    @Reference
    private SysUnitService sysUnitService;
    @Inject
    @Reference
    private SysRoleService sysRoleService;
    @Inject
    private ShiroUtil shiroUtil;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/role/index.html")
    @RequiresPermissions(value={"sys.manager.role"})
    public void index() {
    }

    @At
    @Ok(value="beetl:/platform/sys/role/add.html")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object add(@Param(value="unitid") String unitid, HttpServletRequest req) {
        List list = new ArrayList();
        if (this.shiroUtil.hasRole("sysadmin")) {
            list = this.sysMenuService.query((Condition)Cnd.orderBy().asc("location").asc("path"));
        } else {
            Sql sql = Sqls.create((String)"SELECT roleId FROM sys_user_role WHERE userId=@userId");
            sql.setParam("userId", (Object)StringUtil.getPlatformUid());
            sql.setCallback(Sqls.callback.strs());
            this.sysMenuService.execute(sql);
            List ids = sql.getList(String.class);
            Sql sql1 = Sqls.create((String)"SELECT a.* FROM sys_menu a,sys_role_menu b WHERE a.id=b.menuId AND b.roleId in (@ids)");
            sql1.setParam("ids", (Object)ids.toArray());
            sql1.setEntity(this.sysMenuService.getEntity());
            sql1.setCallback(Sqls.callback.entities());
            list = this.sysMenuService.execute(sql1).getList(Sys_menu.class);
        }
        List datas = this.sysRoleService.getDatas();
        ArrayList<NutMap> menus = new ArrayList<NutMap>();
        for (Sys_menu menu : list) {
            NutMap map = new NutMap();
            for (Sys_menu bt : datas) {
                if (!menu.getPath().equals(bt.getPath().substring(0, bt.getPath().length() - 4))) continue;
                menu.setHasChildren(true);
                break;
            }
            map.put((Object)"id", (Object)menu.getId());
            map.put((Object)"text", (Object)menu.getName());
            map.put((Object)"icon", (Object)Strings.sBlank((Object)menu.getIcon()));
            map.put((Object)"parent", (Object)("".equals(Strings.sNull((Object)menu.getParentId())) ? "#" : menu.getParentId()));
            map.put((Object)"data", (Object)menu.getHref());
            menus.add(map);
        }
        req.setAttribute("menus", (Object)Json.toJson(menus));
        return Strings.isBlank((CharSequence)unitid) ? null : this.sysMenuService.fetch(unitid);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.add"})
    @SLog(tag="\u6dfb\u52a0\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[1].name}")
    public Object addDo(@Param(value="menuIds") String menuIds, @Param(value="..") Sys_role role, HttpServletRequest req) {
        try {
            int num = this.sysRoleService.count((Condition)Cnd.where((String)"code", (String)"=", (Object)role.getCode().trim()));
            if (num > 0) {
                return Result.error((String)"sys.role.code");
            }
            String[] ids = StringUtils.split((String)menuIds, (String)",");
            if ("root".equals(role.getUnitid())) {
                role.setUnitid("");
            }
            Sys_role r = (Sys_role)this.sysRoleService.insert((Object)role);
            for (String s : ids) {
                if (Strings.isEmpty((CharSequence)s)) continue;
                this.sysRoleService.insert("sys_role_menu", Chain.make((String)"roleId", (Object)r.getId()).add("menuId", (Object)s));
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/menu/?"})
    @Ok(value="beetl:/platform/sys/role/menu.html")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object menu(String id, HttpServletRequest req) {
        Sys_role role = (Sys_role)this.sysRoleService.fetch(id);
        List menus = this.sysRoleService.getMenusAndButtons(id);
        List datas = this.sysRoleService.getDatas(role.getId());
        ArrayList<Sys_menu> firstMenus = new ArrayList<Sys_menu>();
        ArrayList<Sys_menu> secondMenus = new ArrayList<Sys_menu>();
        for (Sys_menu menu : menus) {
            for (Sys_menu bt : datas) {
                if (!menu.getPath().equals(bt.getPath().substring(0, bt.getPath().length() - 4))) continue;
                menu.setHasChildren(true);
                break;
            }
            if (menu.getPath().length() == 4) {
                firstMenus.add(menu);
                continue;
            }
            secondMenus.add(menu);
        }
        req.setAttribute("userFirstMenus", firstMenus);
        req.setAttribute("userSecondMenus", secondMenus);
        req.setAttribute("jsonSecondMenus", (Object)Json.toJson(secondMenus));
        return role;
    }

    @At(value={"/editMenu/?"})
    @Ok(value="beetl:/platform/sys/role/editMenu.html")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object editMenu(String roleId, HttpServletRequest req) {
        StringBuilder roleMenuIds = new StringBuilder();
        List list = new ArrayList();
        if (this.shiroUtil.hasRole("sysadmin")) {
            list = this.sysMenuService.query((Condition)Cnd.orderBy().asc("location").asc("path"));
        } else {
            Sql sql = Sqls.create((String)"SELECT roleId FROM sys_user_role WHERE userId=@userId");
            sql.setParam("userId", (Object)StringUtil.getPlatformUid());
            sql.setCallback(Sqls.callback.strs());
            this.sysMenuService.execute(sql);
            List ids = sql.getList(String.class);
            Sql sql1 = Sqls.create((String)"SELECT a.* FROM sys_menu a,sys_role_menu b WHERE a.id=b.menuId AND b.roleId in (@ids)");
            sql1.setParam("ids", (Object)ids.toArray());
            sql1.setEntity(this.sysMenuService.getEntity());
            sql1.setCallback(Sqls.callback.entities());
            list = this.sysMenuService.execute(sql1).getList(Sys_menu.class);
        }
        List datas = this.sysRoleService.getDatas();
        List roleMenu = this.sysRoleService.getMenusAndButtons(roleId);
        for (Sys_menu m : roleMenu) {
            roleMenuIds.append(m.getId() + "#");
        }
        String roleMenuId = roleMenuIds.toString();
        log.debug((Object)roleMenuId);
        ArrayList<NutMap> menus = new ArrayList<NutMap>();
        for (Sys_menu menu : list) {
            NutMap map = new NutMap();
            for (Sys_menu bt : datas) {
                if (!menu.getPath().equals(bt.getPath().substring(0, bt.getPath().length() - 4))) continue;
                menu.setHasChildren(true);
                break;
            }
            map.put((Object)"id", (Object)menu.getId());
            map.put((Object)"text", (Object)menu.getName());
            map.put((Object)"icon", (Object)Strings.sBlank((Object)menu.getIcon()));
            map.put((Object)"parent", (Object)("".equals(Strings.sNull((Object)menu.getParentId())) ? "#" : menu.getParentId()));
            map.put((Object)"data", (Object)menu.getHref());
            if ((menu.getPath().length() >= 16 || !menu.isHasChildren()) && roleMenuId.contains(menu.getId() + "#")) {
                map.put((Object)"state", (Object)NutMap.NEW().addv("selected", (Object)true));
            } else {
                map.put((Object)"state", (Object)NutMap.NEW().addv("selected", (Object)false));
            }
            menus.add(map);
        }
        req.setAttribute("menus", (Object)Json.toJson(menus));
        return Strings.isBlank((CharSequence)roleId) ? null : this.sysRoleService.fetch(roleId);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.menu"})
    @SLog(tag="\u4fee\u6539\u89d2\u8272\u83dc\u5355", msg="\u89d2\u8272\u540d\u79f0:${args[2].getAttribute('name')}")
    public Object editMenuDo(@Param(value="menuIds") String menuIds, @Param(value="roleid") String roleid, HttpServletRequest req) {
        try {
            String[] ids = StringUtils.split((String)menuIds, (String)",");
            this.sysRoleService.clear("sys_role_menu", (Condition)Cnd.where((String)"roleid", (String)"=", (Object)roleid));
            for (String s : ids) {
                if (Strings.isEmpty((CharSequence)s)) continue;
                this.sysRoleService.insert("sys_role_menu", Chain.make((String)"roleId", (Object)roleid).add("menuId", (Object)s));
            }
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleid);
            req.setAttribute("name", (Object)role.getName());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/editUser/?"})
    @Ok(value="beetl:/platform/sys/role/editUser.html")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object editUser(String roleId, HttpServletRequest req) {
        return this.sysRoleService.fetch(roleId);
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object userData(@Param(value="roleid") String roleid, @Param(value="loginname") String loginname, @Param(value="username") String username, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        String sql = "SELECT a.* FROM sys_user a,sys_user_role b WHERE a.id=b.userId ";
        if (!Strings.isBlank((CharSequence)roleid)) {
            sql = sql + " and b.roleId='" + roleid + "'";
        }
        if (!Strings.isBlank((CharSequence)loginname)) {
            sql = sql + " and a.loginname like '%" + loginname + "%'";
        }
        if (!Strings.isBlank((CharSequence)username)) {
            sql = sql + " and a.username like '%" + username + "%'";
        }
        String s = sql;
        if (order != null && order.size() > 0) {
            for (DataTableOrder o : order) {
                DataTableColumn col = columns.get(o.getColumn());
                s = s + " order by a." + Sqls.escapeSqlFieldValue((CharSequence)col.getData()).toString() + " " + o.getDir();
            }
        }
        return this.sysRoleService.data(length, start, draw, Sqls.create((String)sql), Sqls.create((String)s));
    }

    @At
    @Ok(value="beetl:/platform/sys/role/selectUser.html")
    @RequiresPermissions(value={"sys.manager.role"})
    public void selectUser(HttpServletRequest req) {
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object selectData(@Param(value="roleid") String roleid, @Param(value="name") String name, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        String sql = "SELECT a.id,a.loginname,a.username,a.disabled,a.unitid,b.name as unitname FROM sys_user a,sys_unit b WHERE a.unitid=b.id ";
        if (!Strings.isBlank((CharSequence)roleid)) {
            sql = sql + " and a.id NOT IN(SELECT b.userId FROM sys_user_role b WHERE b.roleId='" + roleid + "')";
        }
        if (!Strings.isBlank((CharSequence)name)) {
            sql = sql + " and (a.loginname like '%" + name + "%' or a.username like '%" + name + "%') ";
        }
        String s = sql;
        if (order != null && order.size() > 0) {
            for (DataTableOrder o : order) {
                DataTableColumn col = columns.get(o.getColumn());
                s = s + " order by a." + Sqls.escapeSqlFieldValue((CharSequence)col.getData()).toString() + " " + o.getDir();
            }
        }
        return this.sysRoleService.data(length, start, draw, Sqls.create((String)sql), Sqls.create((String)s));
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.user"})
    @SLog(tag="\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7528\u6237", msg="\u89d2\u8272\u540d\u79f0:${args[2].getAttribute('name')},\u7528\u6237ID:${args[0]}")
    public Object delUser(@Param(value="menuIds") String menuIds, @Param(value="roleid") String roleid, HttpServletRequest req) {
        try {
            String[] ids = StringUtils.split((String)menuIds, (String)",");
            this.sysRoleService.clear("sys_user_role", (Condition)Cnd.where((String)"userId", (String)"in", (Object)ids).and("roleId", "=", (Object)roleid));
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleid);
            req.setAttribute("name", (Object)role.getName());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.user"})
    @SLog(tag="\u6dfb\u52a0\u7528\u6237\u5230\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[2].getAttribute('name')},\u7528\u6237ID:${args[0]}")
    public Object pushUser(@Param(value="menuIds") String menuIds, @Param(value="roleid") String roleid, HttpServletRequest req) {
        try {
            String[] ids;
            for (String s : ids = StringUtils.split((String)menuIds, (String)",")) {
                if (Strings.isEmpty((CharSequence)s)) continue;
                this.sysRoleService.insert("sys_user_role", Chain.make((String)"roleId", (Object)roleid).add("userId", (Object)s));
            }
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleid);
            req.setAttribute("name", (Object)role.getName());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object data(@Param(value="unitid") String unitid, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)unitid) && !"root".equals(unitid)) {
            cnd.and("unitid", "=", (Object)unitid);
        }
        return this.sysRoleService.data(length, start, draw, order, columns, cnd, null);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object tree(@Param(value="pid") String pid) {
        List list = new ArrayList();
        ArrayList tree = new ArrayList();
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (this.shiroUtil.hasRole("sysadmin")) {
            Cnd cnd = Cnd.NEW();
            if (Strings.isBlank((CharSequence)pid)) {
                cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
            } else {
                cnd.and("parentId", "=", (Object)pid);
            }
            cnd.asc("path");
            list = this.sysUnitService.query((Condition)cnd);
            if (Strings.isBlank((CharSequence)pid)) {
                obj.put("id", "root");
                obj.put("text", "\u7cfb\u7edf\u89d2\u8272");
                obj.put("children", false);
                tree.add(obj);
            }
        } else {
            Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
            if (user != null && Strings.isBlank((CharSequence)pid)) {
                list = this.sysUnitService.query((Condition)Cnd.where((String)"id", (String)"=", (Object)user.getUnitid()).asc("path"));
            } else {
                Cnd cnd = Cnd.NEW();
                if (Strings.isBlank((CharSequence)pid)) {
                    cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
                } else {
                    cnd.and("parentId", "=", (Object)pid);
                }
                cnd.asc("path");
                list = this.sysUnitService.query((Condition)cnd);
            }
        }
        for (Sys_unit unit : list) {
            obj = new HashMap();
            obj.put("id", unit.getId());
            obj.put("text", unit.getName());
            obj.put("children", unit.isHasChildren());
            tree.add(obj);
        }
        return tree;
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/sys/role/edit.html")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object edit(String roleId, HttpServletRequest req) {
        Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
        req.setAttribute("unit", this.sysUnitService.fetch(role.getUnitid()));
        return role;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.edit"})
    @SLog(tag="\u4fee\u6539\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[0].name}")
    public Object editDo(@Param(value="..") Sys_role role, @Param(value="oldCode") String oldCode, HttpServletRequest req) {
        try {
            int num;
            if (!Strings.sBlank((Object)oldCode).equals(role.getCode()) && (num = this.sysRoleService.count((Condition)Cnd.where((String)"code", (String)"=", (Object)role.getCode().trim()))) > 0) {
                return Result.error((String)"sys.role.code");
            }
            if ("root".equals(role.getUnitid())) {
                role.setUnitid("");
            }
            role.setOpBy(StringUtil.getPlatformUid());
            role.setOpAt(Long.valueOf(Times.getTS()));
            this.sysRoleService.updateIgnoreNull((Object)role);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.delete"})
    @SLog(tag="\u5220\u9664\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String roleId, HttpServletRequest req) {
        try {
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            if ("sysadmin".equals(role.getCode()) || "public".equals(role.getCode())) {
                return Result.error((String)"system.not.allow");
            }
            this.sysRoleService.del(roleId);
            req.setAttribute("name", (Object)role.getName());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.delete"})
    @SLog(tag="\u6279\u91cf\u5220\u9664\u89d2\u8272", msg="\u89d2\u8272ID\uff1a${args[1].getAttribute('ids')}")
    public Object deletes(@Param(value="roleIds") String[] roleIds, HttpServletRequest req) {
        try {
            Sys_role role = (Sys_role)this.sysRoleService.fetch((Condition)Cnd.where((String)"code", (String)"=", (Object)"sysadmin"));
            Sys_role role1 = (Sys_role)this.sysRoleService.fetch((Condition)Cnd.where((String)"code", (String)"=", (Object)"public"));
            StringBuilder sb = new StringBuilder();
            for (String s : roleIds) {
                if (s.equals(role.getId()) || s.equals(role1.getId())) {
                    return Result.error((String)"system.not.allow");
                }
                sb.append(s).append(",");
            }
            this.sysRoleService.del(roleIds);
            req.setAttribute("ids", (Object)sb.toString());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.edit"})
    @SLog(tag="\u542f\u7528\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object enable(String roleId, HttpServletRequest req) {
        try {
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            this.sysRoleService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)roleId));
            req.setAttribute("name", (Object)role.getName());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.edit"})
    @SLog(tag="\u7981\u7528\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object disable(String roleId, HttpServletRequest req) {
        try {
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            this.sysRoleService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)roleId));
            req.setAttribute("name", (Object)role.getName());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

