/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.cms;

import cn.wizzer.app.cms.modules.models.Cms_article;
import cn.wizzer.app.cms.modules.models.Cms_channel;
import cn.wizzer.app.cms.modules.models.Cms_site;
import cn.wizzer.app.cms.modules.services.CmsArticleService;
import cn.wizzer.app.cms.modules.services.CmsChannelService;
import cn.wizzer.app.cms.modules.services.CmsSiteService;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.adaptor.WhaleAdaptor;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/cms/article"})
public class CmsArticleController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private CmsArticleService cmsArticleService;
    @Inject
    @Reference
    private CmsChannelService cmsChannelService;
    @Inject
    @Reference
    private CmsSiteService cmsSiteService;

    @At(value={"", "/?"})
    @Ok(value="beetl:/platform/cms/article/index.html")
    @RequiresPermissions(value={"cms.content.article"})
    public void index(String siteid, @Param(value="channelId") String channelId, HttpServletRequest req) {
        List siteList = this.cmsSiteService.query();
        if (Strings.isBlank((CharSequence)siteid) && siteList.size() > 0) {
            siteid = ((Cms_site)siteList.get(0)).getId();
        }
        req.setAttribute("siteList", (Object)siteList);
        req.setAttribute("siteid", (Object)Strings.sNull((Object)siteid));
        req.setAttribute("channelId", (Object)Strings.sNull((Object)channelId));
    }

    @At(value={"/tree/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article"})
    public Object tree(String siteid, @Param(value="pid") String pid) {
        List list = this.cmsChannelService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)Strings.sBlank((Object)pid)).and("siteid", "=", (Object)siteid).asc("location").asc("path"));
        ArrayList tree = new ArrayList();
        if (Strings.isBlank((CharSequence)pid)) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("id", "0");
            obj.put("text", "\u6240\u6709\u680f\u76ee");
            obj.put("children", false);
            tree.add(obj);
        }
        for (Cms_channel channel : list) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("id", channel.getId());
            obj.put("text", channel.getName());
            obj.put("children", channel.isHasChildren());
            tree.add(obj);
        }
        return tree;
    }

    @At(value={"/data/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"cms.content.article"})
    public Object data(String siteid, @Param(value="channelId") String channelId, @Param(value="title") String title, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        cnd.and("siteid", "=", (Object)siteid);
        if (!Strings.isBlank((CharSequence)channelId) && !"0".equals(channelId)) {
            cnd.and("channelId", "like", (Object)("%" + channelId + "%"));
        }
        if (!Strings.isBlank((CharSequence)title)) {
            cnd.and("title", "like", (Object)("%" + title + "%"));
        }
        return this.cmsArticleService.data(length, start, draw, order, columns, cnd, null);
    }

    @At(value={"/add/?"})
    @Ok(value="beetl:/platform/cms/article/add.html")
    @RequiresPermissions(value={"cms.content.article"})
    public void add(String siteid, @Param(value="channelId") String channelId, HttpServletRequest req) {
        req.setAttribute("channel", channelId != null && !"0".equals(channelId) ? this.cmsChannelService.fetch(channelId) : null);
        Subject subject = SecurityUtils.getSubject();
        Sys_user user = (Sys_user)subject.getPrincipal();
        req.setAttribute("username", (Object)(user == null ? "" : user.getUsername()));
        req.setAttribute("siteid", (Object)siteid);
        req.setAttribute("channelId", (Object)channelId);
    }

    @At(value={"/addDo/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.add"})
    @SLog(tag="\u6dfb\u52a0\u6587\u7ae0", msg="\u6587\u7ae0\u6807\u9898:${args[1].title}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object addDo(String siteid, @Param(value="..") Cms_article article, @Param(value="beginDate") String beginDate, @Param(value="endDate") String endDate, HttpServletRequest req) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            article.setPublishAt(Long.valueOf(Times.parse((DateFormat)sdf, (String)beginDate).getTime() / 1000L));
            article.setEndAt(Long.valueOf(Times.parse((DateFormat)sdf, (String)endDate).getTime() / 1000L));
            article.setSiteid(siteid);
            article.setStatus(0);
            this.cmsArticleService.insert((Object)article);
            this.cmsArticleService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/cms/article/edit.html")
    @RequiresPermissions(value={"cms.content.article"})
    public Object edit(String id, HttpServletRequest req) {
        Cms_article article = (Cms_article)this.cmsArticleService.fetch(id);
        req.setAttribute("channel", article != null ? this.cmsChannelService.fetch(article.getChannelId()) : null);
        req.setAttribute("siteid", (Object)(article != null ? article.getSiteid() : ""));
        return article;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.edit"})
    @SLog(tag="\u4fee\u6539\u6587\u7ae0", msg="\u6587\u7ae0\u6807\u9898:${args[0].title}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object editDo(@Param(value="..") Cms_article article, @Param(value="beginDate") String beginDate, @Param(value="endDate") String endDate, HttpServletRequest req) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            article.setPublishAt(Long.valueOf(Times.parse((DateFormat)sdf, (String)beginDate).getTime() / 1000L));
            article.setEndAt(Long.valueOf(Times.parse((DateFormat)sdf, (String)endDate).getTime() / 1000L));
            article.setStatus(0);
            this.cmsArticleService.updateIgnoreNull((Object)article);
            this.cmsArticleService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.edit"})
    @SLog(tag="\u53d1\u5e03\u6587\u7ae0", msg="\u6587\u7ae0\u6807\u9898:${args[1].getAttribute('title')}")
    public Object enable(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Cms_article)this.cmsArticleService.fetch(id)).getTitle());
            this.cmsArticleService.update(Chain.make((String)"disabled", (Object)false).add("status", (Object)0), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            this.cmsArticleService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.edit"})
    @SLog(tag="\u53d6\u6d88\u53d1\u5e03", msg="\u6587\u7ae0\u6807\u9898:${args[1].getAttribute('title')}")
    public Object disable(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Cms_article)this.cmsArticleService.fetch(id)).getTitle());
            this.cmsArticleService.update(Chain.make((String)"disabled", (Object)true).add("status", (Object)0), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            this.cmsArticleService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?", "/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.delete"})
    @SLog(tag="\u5220\u9664\u6587\u7ae0", msg="ID:${args[2].getAttribute('id')}")
    public Object delete(String oneId, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            if (ids != null && ids.length > 0) {
                this.cmsArticleService.delete(ids);
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                this.cmsArticleService.delete(oneId);
                req.setAttribute("id", (Object)oneId);
            }
            this.cmsArticleService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

