/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_task;
import cn.wizzer.app.sys.modules.services.SysTaskService;
import cn.wizzer.app.task.modules.services.TaskPlatformService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/task"})
public class SysTaskController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysTaskService sysTaskService;
    @Inject
    @Reference
    private TaskPlatformService taskPlatformService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/task/index.html")
    @RequiresPermissions(value={"sys.manager.task"})
    public void index() {
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.task"})
    public Object data(@Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        return this.sysTaskService.data(length, start, draw, order, columns, cnd, null);
    }

    @At
    @Ok(value="beetl:/platform/sys/task/add.html")
    @RequiresPermissions(value={"sys.manager.task"})
    public void add() {
    }

    @At
    @Ok(value="json")
    @SLog(tag="\u65b0\u5efa\u4efb\u52a1", msg="\u4efb\u52a1\u540d:${args[0].name}")
    @RequiresPermissions(value={"sys.manager.task.add"})
    public Object addDo(@Param(value="..") Sys_task task, HttpServletRequest req) {
        try {
            Sys_task sysTask = (Sys_task)this.sysTaskService.insert((Object)task);
            this.taskPlatformService.add(sysTask.getId(), sysTask.getId(), sysTask.getJobClass(), sysTask.getCron(), sysTask.getNote(), sysTask.getData());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/sys/task/edit.html")
    @RequiresPermissions(value={"sys.manager.task"})
    public Object edit(String id) {
        return this.sysTaskService.fetch(id);
    }

    @At
    @Ok(value="json")
    @SLog(tag="\u4fee\u6539\u4efb\u52a1", msg="\u4efb\u52a1\u540d:${args[0].name}")
    @RequiresPermissions(value={"sys.manager.task.edit"})
    public Object editDo(@Param(value="..") Sys_task task, HttpServletRequest req) {
        try {
            task.setOpBy(StringUtil.getPlatformUid());
            task.setOpAt(Long.valueOf(Times.getTS()));
            this.sysTaskService.updateIgnoreNull((Object)task);
            if (this.taskPlatformService.isExist(task.getId(), task.getId())) {
                this.taskPlatformService.delete(task.getId(), task.getId());
            }
            if (!task.isDisabled()) {
                this.taskPlatformService.add(task.getId(), task.getId(), task.getJobClass(), task.getCron(), task.getNote(), task.getData());
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete", "/delete/?"})
    @Ok(value="json")
    @SLog(tag="\u5220\u9664\u4efb\u52a1", msg="\u4efb\u52a1ID:${args[2].getAttribute('id')}")
    @RequiresPermissions(value={"sys.manager.task.delete"})
    public Object delete(String id, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            if (ids != null && ids.length > 0) {
                List taskList = this.sysTaskService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)ids));
                for (Sys_task sysTask : taskList) {
                    try {
                        if (!this.taskPlatformService.isExist(sysTask.getId(), sysTask.getId())) continue;
                        this.taskPlatformService.delete(sysTask.getId(), sysTask.getId());
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage());
                    }
                }
                this.sysTaskService.delete(ids);
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                Sys_task sysTask = (Sys_task)this.sysTaskService.fetch(id);
                try {
                    if (this.taskPlatformService.isExist(sysTask.getId(), sysTask.getId())) {
                        this.taskPlatformService.delete(sysTask.getId(), sysTask.getId());
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                }
                this.sysTaskService.delete(id);
                req.setAttribute("id", (Object)id);
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.task.edit"})
    @SLog(tag="\u542f\u7528\u4efb\u52a1", msg="\u4efb\u52a1\u540d:${args[1].getAttribute('name')}")
    public Object enable(String id, HttpServletRequest req) {
        try {
            Sys_task sysTask = (Sys_task)this.sysTaskService.fetch(id);
            req.setAttribute("name", (Object)sysTask.getName());
            this.sysTaskService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            if (!this.taskPlatformService.isExist(sysTask.getId(), sysTask.getId())) {
                this.taskPlatformService.add(sysTask.getId(), sysTask.getId(), sysTask.getJobClass(), sysTask.getCron(), sysTask.getNote(), sysTask.getData());
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.task.edit"})
    @SLog(tag="\u7981\u7528\u4efb\u52a1", msg="\u4efb\u52a1\u540d:${args[1].getAttribute('name')}")
    public Object disable(String id, HttpServletRequest req) {
        try {
            Sys_task sysTask = (Sys_task)this.sysTaskService.fetch(id);
            req.setAttribute("name", (Object)sysTask.getName());
            this.sysTaskService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            if (this.taskPlatformService.isExist(sysTask.getId(), sysTask.getId())) {
                this.taskPlatformService.delete(sysTask.getId(), sysTask.getId());
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

