/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.cms;

import cn.wizzer.app.cms.modules.models.Cms_link;
import cn.wizzer.app.cms.modules.models.Cms_link_class;
import cn.wizzer.app.cms.modules.services.CmsLinkClassService;
import cn.wizzer.app.cms.modules.services.CmsLinkService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.adaptor.WhaleAdaptor;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/cms/link/link"})
public class CmsLinkController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private CmsLinkClassService cmsLinkClassService;
    @Inject
    @Reference
    private CmsLinkService cmsLinkService;

    @At(value={"", "/index/", "/index/?"})
    @Ok(value="beetl:/platform/cms/link/link/index.html")
    @RequiresPermissions(value={"cms.link.link"})
    public void index(String classId, HttpServletRequest req) {
        List list = this.cmsLinkClassService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)classId)) {
            classId = ((Cms_link_class)list.get(0)).getId();
        }
        req.setAttribute("list", (Object)list);
        req.setAttribute("classId", (Object)Strings.sBlank((Object)classId));
    }

    @At(value={"/add/", "/add/?"})
    @Ok(value="beetl:/platform/cms/link/link/add.html")
    @RequiresPermissions(value={"cms.link.link"})
    public void add(String classId, HttpServletRequest req) {
        req.setAttribute("classId", (Object)Strings.sBlank((Object)classId));
        req.setAttribute("list", (Object)this.cmsLinkClassService.query((Condition)Cnd.NEW()));
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.link.link.add"})
    @SLog(tag="\u6dfb\u52a0\u94fe\u63a5", msg="\u5206\u7c7b\u540d\u79f0:${args[0].name}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object addDo(@Param(value="..") Cms_link link, HttpServletRequest req) {
        try {
            this.cmsLinkService.insert((Object)link);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/cms/link/link/edit.html")
    @RequiresPermissions(value={"cms.link.link"})
    public Object edit(String id, HttpServletRequest req) {
        Cms_link link = (Cms_link)this.cmsLinkService.fetch(id);
        List list = this.cmsLinkClassService.query((Condition)Cnd.NEW());
        req.setAttribute("list", (Object)list);
        req.setAttribute("classId", (Object)Strings.sBlank((Object)link.getClassId()));
        return link;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.link.link.edit"})
    @SLog(tag="\u4fee\u6539\u94fe\u63a5", msg="\u5206\u7c7b\u540d\u79f0:${args[0].name}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object editDo(@Param(value="..") Cms_link link, HttpServletRequest req) {
        try {
            this.cmsLinkService.updateIgnoreNull((Object)link);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?", "/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.link.link.delete"})
    @SLog(tag="\u5220\u9664\u94fe\u63a5", msg="ID:${args[2].getAttribute('id')}")
    public Object delete(String oneId, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            if (ids != null && ids.length > 0) {
                this.cmsLinkService.delete(ids);
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                this.cmsLinkService.delete(oneId);
                req.setAttribute("id", (Object)oneId);
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/data/", "/data/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"cms.link.link"})
    public Object data(String classId, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)classId)) {
            cnd.and("classId", "=", (Object)classId);
        }
        return this.cmsLinkService.data(length, start, draw, order, columns, cnd, null);
    }
}

