/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Times;

@IocBean
public class DateUtil {
    private static final Locale DEFAULT_LOCALE = Locale.CHINA;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getDate() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd", (Locale)DEFAULT_LOCALE);
    }

    public static String getTime() {
        return DateFormatUtils.format((Date)new Date(), (String)"HH:mm:ss", (Locale)DEFAULT_LOCALE);
    }

    public static String getDateTime() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss", (Locale)DEFAULT_LOCALE);
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss", (Locale)DEFAULT_LOCALE);
    }

    public static String format(Date date, String f) {
        if (date == null) {
            return "";
        }
        return DateFormatUtils.format((Date)date, (String)f, (Locale)DEFAULT_LOCALE);
    }

    public static String getDate(long time) {
        return DateFormatUtils.format((Date)new Date(time * 1000L), (String)"yyyy-MM-dd HH:mm:ss", (Locale)DEFAULT_LOCALE);
    }

    public static String getDate(long time, String f) {
        return DateFormatUtils.format((Date)new Date(time * 1000L), (String)f, (Locale)DEFAULT_LOCALE);
    }

    public static int getTime(String date) {
        try {
            return (int)(Times.parse((DateFormat)sdf, (String)date).getTime() / 1000L);
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public static int getTime(SimpleDateFormat sdf, String date) {
        try {
            return (int)(Times.parse((DateFormat)sdf, (String)date).getTime() / 1000L);
        }
        catch (ParseException e) {
            return 0;
        }
    }
}

