/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.open;

import cn.wizzer.app.web.commons.filter.ApiHeaderSignFilter;
import cn.wizzer.app.web.commons.utils.SignCheckUtil;
import cn.wizzer.framework.base.Result;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nutz.filepool.NutFilePool;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.By;
import org.nutz.mvc.annotation.Filters;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadAdaptor;

@IocBean
@At(value={"/open/api/file"})
public class ApiFileTestController {
    private static final Log log = Logs.get();
    @Inject(value="refer:tmpFilePool")
    private NutFilePool tmpFilePool;
    @Inject
    private SignCheckUtil signCheckUtil;

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At(value={"/upload/image_by_sign"})
    @Ok(value="json")
    public Object upload1(@Param(value="Filedata") TempFile tf, @Param(value="..") NutMap params, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            log.debug((Object)("params::" + Json.toJson((Object)params)));
            params.remove((Object)"Filedata");
            Result result = this.signCheckUtil.checkSign((Map<String, Object>)params);
            if (result == null) {
                return Result.error((String)"\u7b7e\u540d\u51fa\u9519");
            }
            if (result.getCode() != 0) {
                return result;
            }
            if (err != null && err.getAdaptorErr() != null) {
                return Result.error((String)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            long fileId = this.tmpFilePool.getFileId(tf.getFile());
            String suffix = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().indexOf("."));
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("file_id", (Object)fileId).addv("file_suffix", (Object)suffix));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            return Result.error((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
        }
    }

    @Filters(value={@By(type=ApiHeaderSignFilter.class)})
    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At(value={"/upload/image_by_header_sign"})
    @Ok(value="json")
    public Object upload2(@Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return Result.error((String)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            long fileId = this.tmpFilePool.getFileId(tf.getFile());
            String suffix = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().indexOf("."));
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("file_id", (Object)fileId).addv("file_suffix", (Object)suffix));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            return Result.error((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
        }
    }
}

