/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.filter;

import cn.wizzer.app.web.commons.utils.SignCheckUtil;
import cn.wizzer.framework.base.Result;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionFilter;
import org.nutz.mvc.View;
import org.nutz.mvc.view.UTF8JsonView;

public class ApiHeaderSignFilter
implements ActionFilter {
    private static final Log log = Logs.get();

    public View match(ActionContext context) {
        try {
            SignCheckUtil signCheckUtil = (SignCheckUtil)context.getIoc().get(SignCheckUtil.class);
            Map<String, Object> paramMap = this.getHeaderParameterMap(context.getRequest());
            log.debug((Object)("paramMap:::\r\n" + Json.toJson(paramMap)));
            Result result = signCheckUtil.checkSign(paramMap);
            if (result == null) {
                return new UTF8JsonView(JsonFormat.compact()).setData((Object)Result.error((String)"\u7b7e\u540d\u51fa\u9519"));
            }
            if (result.getCode() == 0) {
                return null;
            }
            return new UTF8JsonView(JsonFormat.compact()).setData((Object)result);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new UTF8JsonView(JsonFormat.compact()).setData((Object)Result.error((int)-1, (String)"\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    private Map<String, Object> getHeaderParameterMap(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String paramName = (String)names.nextElement();
            if (!"appid".equals(paramName) && !"sign".equals(paramName) && !"nonce".equals(paramName) && !"timestamp".equals(paramName)) continue;
            map.put(paramName, request.getHeader(paramName));
        }
        return map;
    }
}

