/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.task.commons.core;

import cn.wizzer.app.sys.modules.models.Sys_task;
import cn.wizzer.app.sys.modules.services.SysTaskService;
import cn.wizzer.app.task.commons.base.Globals;
import cn.wizzer.app.task.modules.services.TaskPlatformService;
import com.alibaba.dubbo.config.annotation.Reference;
import java.lang.management.ManagementFactory;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.nutz.boot.NbApp;
import org.nutz.dao.Dao;
import org.nutz.dao.impl.FileSqlManager;
import org.nutz.dao.sql.Sql;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Mirror;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.Modules;
import org.quartz.Scheduler;

@IocBean(create="init", depose="depose")
@Modules(packages={"cn.wizzer"})
public class TaskMainLauncher {
    private static final Log log = Logs.get();
    @Inject
    private TaskPlatformService taskPlatformService;
    @Inject
    @Reference
    private SysTaskService sysTaskService;
    @Inject(value="refer:$ioc")
    private Ioc ioc;
    @Inject
    private Dao dao;

    public static void main(String[] args) throws Exception {
        NbApp nb = new NbApp().setArgs(args).setPrintProcDoc(true);
        nb.getAppContext().setMainPackage("cn.wizzer");
        nb.run();
    }

    public void init() {
        if (!this.dao.exists("sys_qrtz_triggers")) {
            Sql[] sqlsq;
            String dbType = this.dao.getJdbcExpert().getDatabaseType();
            log.debug((Object)("dbType:::" + dbType));
            FileSqlManager fmq = new FileSqlManager(new String[]{"quartz/" + dbType.toLowerCase() + ".sql"});
            List sqlListq = fmq.createCombo(fmq.keys());
            for (Sql sql : sqlsq = sqlListq.toArray(new Sql[sqlListq.size()])) {
                this.dao.execute(sql);
            }
        }
        if (0 == this.sysTaskService.count()) {
            Sys_task task = new Sys_task();
            task.setDisabled(true);
            task.setName("\u6d4b\u8bd5\u4efb\u52a1");
            task.setJobClass("cn.wizzer.app.task.commons.ext.quartz.job.TestJob");
            task.setCron("*/5 * * * * ?");
            task.setData("{\"hi\":\"Wechat:wizzer | send red packets of support,thank u\"}");
            task.setNote("\u5fae\u4fe1\u53f7\uff1awizzer | \u6b22\u8fce\u53d1\u9001\u7ea2\u5305\u4ee5\u793a\u652f\u6301\uff0c\u591a\u8c22\u3002\u3002");
            this.sysTaskService.insert((Object)task);
        }
        ((Globals)this.ioc.get(Globals.class)).init(this.sysTaskService);
    }

    public void depose() {
        try {
            Mirror.me(Class.forName("com.mysql.jdbc.AbandonedConnectionCleanupThread")).invoke(null, "shutdown", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ((Scheduler)this.ioc.get(Scheduler.class)).shutdown(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration<Driver> en = DriverManager.getDrivers();
        while (en.hasMoreElements()) {
            try {
                Driver driver = en.nextElement();
                String className = driver.getClass().getName();
                log.debug((Object)("deregisterDriver: " + className));
                DriverManager.deregisterDriver(driver);
            }
            catch (Exception driver) {}
        }
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("com.alibaba.druid:type=MockDriver");
            if (mbeanServer.isRegistered(objectName)) {
                mbeanServer.unregisterMBean(objectName);
            }
            if (mbeanServer.isRegistered(objectName = new ObjectName("com.alibaba.druid:type=DruidDriver"))) {
                mbeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

