/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.sys.modules.services.impl;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.models.Sys_role;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.sys.modules.services.SysMenuService;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.framework.base.service.BaseServiceImpl;
import com.alibaba.dubbo.config.annotation.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.sql.Sql;
import org.nutz.ioc.aop.Aop;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.plugins.wkcache.annotation.CacheDefaults;
import org.nutz.plugins.wkcache.annotation.CacheRemoveAll;
import org.nutz.plugins.wkcache.annotation.CacheResult;

@IocBean(args={"refer:dao"})
@Service(interfaceClass=SysUserService.class)
@CacheDefaults(cacheName="sys_user")
public class SysUserServiceImpl
extends BaseServiceImpl<Sys_user>
implements SysUserService {
    @Inject
    private SysMenuService sysMenuService;

    public SysUserServiceImpl(Dao dao) {
        super(dao);
    }

    @CacheResult(cacheKey="${args[0].id}_getRoleCodeList")
    public List<String> getRoleCodeList(Sys_user user) {
        this.dao().fetchLinks((Object)user, "roles");
        ArrayList<String> roleNameList = new ArrayList<String>();
        for (Sys_role role : user.getRoles()) {
            if (role.isDisabled()) continue;
            roleNameList.add(role.getCode());
        }
        return roleNameList;
    }

    @CacheResult(cacheKey="${args[0].id}_fillMenu")
    public Sys_user fillMenu(Sys_user user) {
        user.setMenus(this.getMenus(user.getId()));
        ArrayList<Sys_menu> firstMenus = new ArrayList<Sys_menu>();
        HashMap<String, ArrayList<Sys_menu>> secondMenus = new HashMap<String, ArrayList<Sys_menu>>();
        for (Sys_menu menu : user.getMenus()) {
            if (menu.getPath().length() > 4) {
                ArrayList<Sys_menu> s = (ArrayList<Sys_menu>)secondMenus.get(this.getParentPath(menu.getPath()));
                if (s == null) {
                    s = new ArrayList<Sys_menu>();
                }
                s.add(menu);
                secondMenus.put(this.getParentPath(menu.getPath()), s);
                continue;
            }
            if (menu.getPath().length() != 4) continue;
            firstMenus.add(menu);
        }
        user.setFirstMenus(firstMenus);
        user.setSecondMenus(secondMenus);
        if (!Strings.isBlank((CharSequence)user.getCustomMenu())) {
            user.setCustomMenus(this.sysMenuService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)user.getCustomMenu().split(","))));
        }
        return user;
    }

    @CacheResult
    public List<Sys_menu> getMenus(String userId) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and  b.roleId in(select c.roleId from sys_user_role c,sys_role d where c.roleId=d.id and c.userId=@userId and d.disabled=@f) and a.disabled=@f and a.showit=@t and a.type='menu' order by a.location ASC,a.path asc");
        sql.params().set("userId", (Object)userId);
        sql.params().set("f", (Object)false);
        sql.params().set("t", (Object)true);
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    @CacheResult
    public List<Sys_menu> getMenusAndButtons(String userId) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and  b.roleId in(select c.roleId from sys_user_role c,sys_role d where c.roleId=d.id and c.userId=@userId and d.disabled=@f) and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("userId", (Object)userId);
        sql.params().set("f", (Object)false);
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    @CacheResult
    public List<Sys_menu> getDatas(String userId) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId  and  b.roleId in(select c.roleId from sys_user_role c,sys_role d where c.roleId=d.id and c.userId=@userId and d.disabled=@f) and a.disabled=@f and a.type='data' order by a.location ASC,a.path asc");
        sql.params().set("userId", (Object)userId);
        sql.params().set("f", (Object)false);
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    @Aop(value={"txREAD_COMMITTED"})
    public void deleteById(String userId) {
        this.dao().clear("sys_user_unit", (Condition)Cnd.where((String)"userId", (String)"=", (Object)userId));
        this.dao().clear("sys_user_role", (Condition)Cnd.where((String)"userId", (String)"=", (Object)userId));
        this.dao().clear("sys_user", (Condition)Cnd.where((String)"id", (String)"=", (Object)userId));
    }

    @Aop(value={"txREAD_COMMITTED"})
    public void deleteByIds(String[] userIds) {
        this.dao().clear("sys_user_unit", (Condition)Cnd.where((String)"userId", (String)"in", (Object)userIds));
        this.dao().clear("sys_user_role", (Condition)Cnd.where((String)"userId", (String)"in", (Object)userIds));
        this.dao().clear("sys_user", (Condition)Cnd.where((String)"id", (String)"in", (Object)userIds));
    }

    @CacheResult
    public List<Sys_menu> getRoleMenus(String userId, String pid) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and $m and b.roleId in(select c.roleId from sys_user_role c,sys_role d where c.roleId=d.id and c.userId=@userId and d.disabled=@f) and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("userId", (Object)userId);
        sql.params().set("f", (Object)false);
        if (Strings.isNotBlank((CharSequence)pid)) {
            sql.vars().set("m", (Object)("a.parentId='" + pid + "'"));
        } else {
            sql.vars().set("m", (Object)"(a.parentId='' or a.parentId is null)");
        }
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    @CacheResult
    public boolean hasChildren(String userId, String pid) {
        Sql sql = Sqls.create((String)"select count(*) from sys_menu a,sys_role_menu b where a.id=b.menuId and $m and b.roleId in(select c.roleId from sys_user_role c,sys_role d where c.roleId=d.id and c.userId=@userId and d.disabled=@f) and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("userId", (Object)userId);
        sql.params().set("f", (Object)false);
        if (Strings.isNotBlank((CharSequence)pid)) {
            sql.vars().set("m", (Object)("a.parentId='" + pid + "'"));
        } else {
            sql.vars().set("m", (Object)"(a.parentId='' or a.parentId is null)");
        }
        sql.setCallback(Sqls.callback.integer());
        this.dao().execute(sql);
        return sql.getInt() > 0;
    }

    @CacheRemoveAll
    public void clearCache() {
    }
}

