/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.sys.modules.services.impl;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.models.Sys_role;
import cn.wizzer.app.sys.modules.models.Sys_unit;
import cn.wizzer.app.sys.modules.services.SysRoleService;
import cn.wizzer.framework.base.service.BaseServiceImpl;
import cn.wizzer.framework.page.Pagination;
import com.alibaba.dubbo.config.annotation.Service;
import java.util.ArrayList;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.sql.Sql;
import org.nutz.ioc.aop.Aop;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.plugins.wkcache.annotation.CacheDefaults;
import org.nutz.plugins.wkcache.annotation.CacheRemoveAll;
import org.nutz.plugins.wkcache.annotation.CacheResult;

@IocBean(args={"refer:dao"})
@Service(interfaceClass=SysRoleService.class)
@CacheDefaults(cacheName="sys_role")
public class SysRoleServiceImpl
extends BaseServiceImpl<Sys_role>
implements SysRoleService {
    public SysRoleServiceImpl(Dao dao) {
        super(dao);
    }

    @CacheResult
    public List<Sys_menu> getMenusAndButtons(String roleId) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and b.roleId=@roleId and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("roleId", (Object)roleId);
        sql.params().set("f", (Object)false);
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    @CacheResult
    public List<Sys_menu> getDatas(String roleId) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and b.roleId=@roleId and a.type='data' and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("roleId", (Object)roleId);
        sql.params().set("f", (Object)false);
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    @CacheResult
    public List<Sys_menu> getDatas() {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and a.type='data' order by a.location ASC,a.path asc");
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    @CacheResult(cacheKey="${args[0].id}_getPermissionNameList")
    public List<String> getPermissionNameList(Sys_role role) {
        this.dao().fetchLinks((Object)role, "menus");
        ArrayList<String> list = new ArrayList<String>();
        for (Sys_menu menu : role.getMenus()) {
            if (Strings.isEmpty((CharSequence)menu.getPermission()) || menu.isDisabled()) continue;
            list.add(menu.getPermission());
        }
        return list;
    }

    @Aop(value={"txREAD_COMMITTED"})
    public void del(String roleid) {
        this.dao().clear("sys_user_role", (Condition)Cnd.where((String)"roleId", (String)"=", (Object)roleid));
        this.dao().clear("sys_role_menu", (Condition)Cnd.where((String)"roleId", (String)"=", (Object)roleid));
        this.delete(roleid);
    }

    @Aop(value={"txREAD_COMMITTED"})
    public void del(String[] roleids) {
        this.dao().clear("sys_user_role", (Condition)Cnd.where((String)"roleId", (String)"in", (Object)roleids));
        this.dao().clear("sys_role_menu", (Condition)Cnd.where((String)"roleId", (String)"in", (Object)roleids));
        this.delete(roleids);
    }

    @CacheResult
    public List<Sys_menu> getRoleMenus(String roleId, String pid) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and $m and b.roleId=@roleId and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("roleId", (Object)roleId);
        sql.params().set("f", (Object)false);
        if (Strings.isNotBlank((CharSequence)pid)) {
            sql.vars().set("m", (Object)("a.parentId='" + pid + "'"));
        } else {
            sql.vars().set("m", (Object)"(a.parentId='' or a.parentId is null)");
        }
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    @CacheResult
    public boolean hasChildren(String roleId, String pid) {
        Sql sql = Sqls.create((String)"select count(*) from sys_menu a,sys_role_menu b where a.id=b.menuId and $m and b.roleId=@roleId and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("roleId", (Object)roleId);
        sql.params().set("f", (Object)false);
        if (Strings.isNotBlank((CharSequence)pid)) {
            sql.vars().set("m", (Object)("a.parentId='" + pid + "'"));
        } else {
            sql.vars().set("m", (Object)"(a.parentId='' or a.parentId is null)");
        }
        sql.setCallback(Sqls.callback.integer());
        this.dao().execute(sql);
        return sql.getInt() > 0;
    }

    public Pagination userSearch(String roleId, String keyword, boolean isAdmin, Sys_unit sysUnit) {
        Sql sql = DB.ORACLE.name().equals(this.dao().getJdbcExpert().getDatabaseType()) ? Sqls.create((String)"SELECT a.id AS VALUE,a.loginname||'('||a.username||')' AS label,a.disabled,a.unitid,b.name as unitname FROM sys_user a,sys_unit b WHERE a.unitid=b.id  and a.id NOT IN(SELECT b.userId FROM sys_user_role b WHERE b.roleId=@roleId) $s1 $s2 order by a.opAt desc") : Sqls.create((String)"SELECT a.id AS VALUE,CONCAT(a.loginname,'(',a.username,')') AS label,a.disabled,a.unitid,b.name as unitname FROM sys_user a,sys_unit b WHERE a.unitid=b.id  and a.id NOT IN(SELECT b.userId FROM sys_user_role b WHERE b.roleId=@roleId) $s1 $s2 order by a.opAt desc");
        sql.params().set("roleId", (Object)roleId);
        if (!isAdmin) {
            String menuPath = sysUnit.getPath();
            sql.vars().set("s1", (Object)(" and b.path like '" + menuPath + "%'"));
        }
        if (Strings.isNotBlank((CharSequence)keyword)) {
            sql.vars().set("s2", (Object)(" and (a.loginname like '%" + keyword + "%' or a.username like '%" + keyword + "%')"));
        }
        return this.listPage(1, 10, sql);
    }

    @CacheRemoveAll
    public void clearCache() {
    }
}

