/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.sys.modules.services.impl;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.models.Sys_role;
import cn.wizzer.app.sys.modules.services.SysRoleService;
import cn.wizzer.framework.base.service.BaseServiceImpl;
import com.alibaba.dubbo.config.annotation.Service;
import java.util.ArrayList;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.sql.Sql;
import org.nutz.ioc.aop.Aop;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;

@IocBean(args={"refer:dao"})
@Service(interfaceClass=SysRoleService.class)
public class SysRoleServiceImpl
extends BaseServiceImpl<Sys_role>
implements SysRoleService {
    public SysRoleServiceImpl(Dao dao) {
        super(dao);
    }

    public List<Sys_menu> getMenusAndButtons(String roleId) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and b.roleId=@roleId and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("roleId", (Object)roleId);
        sql.params().set("f", (Object)false);
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    public List<Sys_menu> getDatas(String roleId) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and b.roleId=@roleId and a.type='data' and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("roleId", (Object)roleId);
        sql.params().set("f", (Object)false);
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    public List<Sys_menu> getDatas() {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and a.type='data' order by a.location ASC,a.path asc");
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    public List<String> getPermissionNameList(Sys_role role) {
        this.dao().fetchLinks((Object)role, "menus");
        ArrayList<String> list = new ArrayList<String>();
        for (Sys_menu menu : role.getMenus()) {
            if (Strings.isEmpty((CharSequence)menu.getPermission()) || menu.isDisabled()) continue;
            list.add(menu.getPermission());
        }
        return list;
    }

    @Aop(value={"txREAD_COMMITTED"})
    public void del(String roleid) {
        this.dao().clear("sys_user_role", (Condition)Cnd.where((String)"roleId", (String)"=", (Object)roleid));
        this.dao().clear("sys_role_menu", (Condition)Cnd.where((String)"roleId", (String)"=", (Object)roleid));
        this.delete(roleid);
    }

    @Aop(value={"txREAD_COMMITTED"})
    public void del(String[] roleids) {
        this.dao().clear("sys_user_role", (Condition)Cnd.where((String)"roleId", (String)"in", (Object)roleids));
        this.dao().clear("sys_role_menu", (Condition)Cnd.where((String)"roleId", (String)"in", (Object)roleids));
        this.delete(roleids);
    }

    public List<Sys_menu> getRoleMenus(String roleId, String pid) {
        Sql sql = Sqls.create((String)"select distinct a.* from sys_menu a,sys_role_menu b where a.id=b.menuId and $m and b.roleId=@roleId and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("roleId", (Object)roleId);
        sql.params().set("f", (Object)false);
        if (Strings.isNotBlank((CharSequence)pid)) {
            sql.vars().set("m", (Object)("a.parentId='" + pid + "'"));
        } else {
            sql.vars().set("m", (Object)"(a.parentId='' or a.parentId is null)");
        }
        Entity entity = this.dao().getEntity(Sys_menu.class);
        sql.setEntity(entity);
        sql.setCallback(Sqls.callback.entities());
        this.dao().execute(sql);
        return sql.getList(Sys_menu.class);
    }

    public boolean hasChildren(String roleId, String pid) {
        Sql sql = Sqls.create((String)"select count(*) from sys_menu a,sys_role_menu b where a.id=b.menuId and $m and b.roleId=@roleId and a.disabled=@f order by a.location ASC,a.path asc");
        sql.params().set("roleId", (Object)roleId);
        sql.params().set("f", (Object)false);
        if (Strings.isNotBlank((CharSequence)pid)) {
            sql.vars().set("m", (Object)("a.parentId='" + pid + "'"));
        } else {
            sql.vars().set("m", (Object)"(a.parentId='' or a.parentId is null)");
        }
        sql.setCallback(Sqls.callback.integer());
        this.dao().execute(sql);
        return sql.getInt() > 0;
    }
}

