/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.cms.commons.core;

import cn.wizzer.app.cms.commons.ig.RedisIdGenerator;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import org.nutz.boot.NbApp;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Record;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Daos;
import org.nutz.el.opt.RunMethod;
import org.nutz.el.opt.custom.CustomMake;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.Modules;
import redis.clients.jedis.Jedis;

@IocBean(create="init", depose="depose")
@Modules(packages={"cn.wizzer"})
public class DubboRpcCmsMainLauncher {
    private static final Log log = Logs.get();
    @Inject(value="refer:$ioc")
    private Ioc ioc;
    @Inject
    private Dao dao;
    @Inject
    private PropertiesProxy conf;
    @Inject
    private JedisAgent jedisAgent;

    public static void main(String[] args) throws Exception {
        NbApp nb = new NbApp().setArgs(args).setPrintProcDoc(true);
        nb.getAppContext().setMainPackage("cn.wizzer");
        nb.run();
    }

    public void init() {
        CustomMake.me().register("ig", (RunMethod)this.ioc.get(RedisIdGenerator.class));
        try {
            Daos.createTablesInPackage((Dao)this.dao, (String)"cn.wizzer.app.cms", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initRedisIg() {
        long a = System.currentTimeMillis();
        try (Jedis jedis = this.jedisAgent.getResource();){
            if (!"mysql".equalsIgnoreCase(this.dao.getJdbcExpert().getDatabaseType())) {
                log.info((Object)"wait for you ...");
                return;
            }
            Sql sql = Sqls.create((String)("SELECT table_name FROM information_schema.columns WHERE table_schema='" + this.conf.get("ig.db.name", "") + "' AND column_name='id'"));
            sql.setCallback(Sqls.callback.strs());
            this.dao.execute(sql);
            List tableNameList = sql.getList(String.class);
            for (String tableName : tableNameList) {
                List list = this.dao.query(tableName, (Condition)Cnd.NEW().desc("id"), new Pager().setPageSize(1).setPageNumber(1));
                if (list.size() <= 0) continue;
                String id = ((Record)list.get(0)).getString("id");
                if (!Strings.isMatch((Pattern)Pattern.compile("^.*[\\d]{16}$"), (String)id)) continue;
                String ym = id.substring(id.length() - 16, id.length() - 10);
                if (!Strings.isBlank((CharSequence)jedis.get("nutzwk:ig:" + tableName.toUpperCase() + ym))) continue;
                jedis.set("nutzwk:ig:" + tableName.toUpperCase() + ym, String.valueOf(Long.valueOf(id.substring(id.length() - 10, id.length()))));
            }
        }
        long b = System.currentTimeMillis();
        log.info((Object)("init redis ig time::" + (b - a) + "ms"));
    }

    public void depose() {
        try {
            Mirror.me(Class.forName("com.mysql.jdbc.AbandonedConnectionCleanupThread")).invoke(null, "shutdown", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Enumeration<Driver> en = DriverManager.getDrivers();
        while (en.hasMoreElements()) {
            try {
                Driver driver = en.nextElement();
                String className = driver.getClass().getName();
                log.debug((Object)("deregisterDriver: " + className));
                DriverManager.deregisterDriver(driver);
            }
            catch (Exception exception) {}
        }
    }
}

