/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.code.commons.builder;

import cn.wizzer.app.code.commons.builder.ColumnDescriptor;
import cn.wizzer.app.code.commons.builder.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.atteo.evo.inflector.English;
import org.nutz.lang.Strings;

public class TableDescriptor {
    private final String basePackageName;
    private final String baseUri;
    private final List<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
    public final String name;
    private String entityName;
    private String pkType;
    private String comment;
    private String label = "\u9879";
    private String serPackageName;
    private String modPackageName;

    public TableDescriptor(String name, String entityName, String basePackageName, String baseUri, String serPackageName, String modPackageName) {
        this.name = name;
        this.entityName = entityName;
        this.basePackageName = basePackageName;
        this.serPackageName = serPackageName;
        this.modPackageName = modPackageName;
        if (!baseUri.endsWith("/")) {
            baseUri = baseUri + "/";
        }
        this.baseUri = baseUri;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getName() {
        return this.name;
    }

    public String getPlural() {
        return English.plural((String)this.name);
    }

    public String getPkType() {
        return this.pkType;
    }

    public void setPkType(String pkType) {
        this.pkType = pkType;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public List<ColumnDescriptor> getColumns() {
        return this.columns;
    }

    public void addColumn(ColumnDescriptor column) {
        this.columns.add(column);
    }

    public String getClassName() {
        return this.getEntityClassName();
    }

    public String getModelName() {
        if (this.getName().contains("_")) {
            return this.getName().toLowerCase().substring(0, this.getName().indexOf("_"));
        }
        return this.getName().toLowerCase();
    }

    public String getModelSubName() {
        if (this.getName().contains("_")) {
            return this.getName().toLowerCase().substring(this.getName().indexOf("_") + 1);
        }
        return this.getName().toLowerCase();
    }

    public String getLocalePath() {
        return this.getName().toLowerCase().replaceAll("_", ".");
    }

    public String getPermissions() {
        if (this.getName().contains("_")) {
            return this.baseUri.replaceFirst("/", "").replaceAll("/", ".") + this.getName().substring(this.getName().indexOf("_") + 1).replace("_", ".");
        }
        return this.baseUri + this.getName();
    }

    public String getUriPrefix() {
        if (this.getName().contains("_")) {
            return this.baseUri + this.getName().substring(this.getName().indexOf("_") + 1).replace("_", "/");
        }
        return this.baseUri + this.getName();
    }

    public String getViewBasePath() {
        if (this.getName().contains("_")) {
            return this.baseUri.replaceFirst("/", "") + this.getName().substring(this.getName().indexOf("_") + 1).replace("_", "/");
        }
        return this.baseUri.replaceFirst("/", "") + this.getName().replace("_", "/");
    }

    public String getModPackageName() {
        return this.modPackageName;
    }

    public void setModPackageName(String modPackageName) {
        this.modPackageName = modPackageName;
    }

    public String getSerPackageName() {
        return this.serPackageName;
    }

    public void setSerPackageName(String serPackageName) {
        this.serPackageName = serPackageName;
    }

    public String getEntityClassName() {
        if (Strings.isBlank((CharSequence)this.entityName)) {
            return Utils.UPPER_CAMEL(this.name);
        }
        return this.entityName;
    }

    public String getEntityFullClassName() {
        return this.getModPackageName() + "." + this.getEntityClassName();
    }

    public String getServiceFullClassName() {
        return this.getSerPackageName() + "." + this.getServiceClassName();
    }

    public String getEntityInstanceName() {
        return Utils.LOWER_CAMEL(this.name);
    }

    public String getEntityInstancesName() {
        return this.getEntityInstanceName() + "s";
    }

    public String getServiceInstanceName() {
        return this.getEntityInstanceName() + "Service";
    }

    public String getServiceClassName() {
        return Utils.UPPER_CAMEL(this.getEntityClassName()) + "Service";
    }

    public String getControllerClassName() {
        return Utils.UPPER_CAMEL(this.getEntityClassName()) + "Controller";
    }

    public void addPrimaryKeyColumn(String columnName) {
        for (ColumnDescriptor column : this.columns) {
            if (!column.columnName.equals(columnName)) continue;
            column.primary = true;
            break;
        }
    }

    public ColumnDescriptor getPrimaryColumn() {
        for (ColumnDescriptor column : this.columns) {
            if (!column.primary) continue;
            return column;
        }
        return null;
    }

    public String getPrimaryType() {
        ColumnDescriptor columnDescriptor = this.getPrimaryColumn();
        if (columnDescriptor == null) {
            return null;
        }
        return columnDescriptor.getSimpleJavaTypeName();
    }

    public String getTableAnnotation() {
        return "@Table";
    }

    public List<String> getImports() {
        LinkedHashSet<String> klasses = new LinkedHashSet<String>();
        for (ColumnDescriptor column : this.columns) {
            String klass = column.getJavaType();
            if (klass.startsWith("java.lang") || klass.indexOf(46) == -1) continue;
            klasses.add(column.getJavaType());
        }
        ArrayList<String> imports = new ArrayList<String>();
        imports.addAll(klasses);
        imports.add(null);
        imports.add(Serializable.class.getName());
        imports.add(null);
        klasses.clear();
        if (klasses.size() > 0) {
            imports.addAll(klasses);
            imports.add(null);
        }
        return imports;
    }

    public List<ColumnDescriptor> getEnumColumns() {
        ArrayList<ColumnDescriptor> result = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor column : this.columns) {
            if (!column.isEnum()) continue;
            result.add(column);
        }
        return result;
    }

    public String getQueryColumns(String op) {
        ArrayList<String> result = new ArrayList<String>();
        for (ColumnDescriptor column : this.columns) {
            if (!op.equals(column.getQueryOperator())) continue;
            result.add("\"" + column.columnName + "\"");
        }
        if (result.isEmpty()) {
            return null;
        }
        return "";
    }

    public List<ColumnDescriptor> getSearchableColumns() {
        ArrayList<ColumnDescriptor> result = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor column : this.columns) {
            if (Strings.isBlank((CharSequence)column.getQueryOperator())) continue;
            result.add(column);
        }
        return result;
    }

    public List<ColumnDescriptor> getLabeledColumns() {
        ArrayList<ColumnDescriptor> result = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor column : this.columns) {
            if (column.getComment() == null || column.primary) continue;
            result.add(column);
        }
        return result;
    }

    public String[] getLabeledColumnNames() {
        List<ColumnDescriptor> columnDescriptors = this.getLabeledColumns();
        ArrayList<String> result = new ArrayList<String>();
        for (ColumnDescriptor descriptor : columnDescriptors) {
            result.add(descriptor.getFieldName());
        }
        return result.toArray(new String[0]);
    }

    public String getLabeledColumnNamesString() {
        StringBuilder buf = new StringBuilder();
        for (String name : this.getLabeledColumnNames()) {
            buf.append("\"").append(name).append("\"").append(", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    public List<ColumnDescriptor> getIndexColumns() {
        ArrayList<ColumnDescriptor> result = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor column : this.columns) {
            if (Strings.isBlank((CharSequence)column.getLabel()) || "id".equalsIgnoreCase(column.columnName)) continue;
            result.add(column);
        }
        return result;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

