/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.code.commons.builder;

import cn.wizzer.app.code.commons.builder.ColumnDescriptor;
import cn.wizzer.app.code.commons.builder.Loader;
import cn.wizzer.app.code.commons.builder.TableDescriptor;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.entity.annotation.Name;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.ioc.Ioc;
import org.nutz.lang.Files;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class EntityDescLoader
extends Loader {
    private static final Log log = Logs.get();

    @Override
    public Map<String, TableDescriptor> loadTables(Ioc ioc, String basePackageName, String basePath, String baseUri, String servPackageName, String modPackageName) throws Exception {
        String packageName = modPackageName;
        String filePath = packageName.replaceAll("\\.", "\\/");
        URL url = Loader.class.getClassLoader().getResource(filePath);
        String path = url != null ? url.getPath() : "target/classes/" + filePath;
        File f = Files.createDirIfNoExists((String)path);
        log.debug((Object)("classes dir = " + f.getAbsolutePath()));
        String abstractPath = URLDecoder.decode(path, "utf8");
        File[] files = Files.lsFile((String)abstractPath, null);
        HashMap<String, TableDescriptor> tables = new HashMap<String, TableDescriptor>();
        for (File file : files) {
            Field[] fields;
            Class<?> modelClass;
            Mirror mirror;
            Table tableAnno;
            String fileName = file.getName().split("\\.")[0];
            String className = packageName + "." + fileName;
            if (className.contains(".Model") || className.contains(".em") || className.contains("$") || (tableAnno = (Table)(mirror = Mirror.me(modelClass = Class.forName(className))).getAnnotation(Table.class)) == null) continue;
            String tableName = tableAnno.value();
            String entityName = modelClass.getSimpleName();
            TableDescriptor table = new TableDescriptor(tableName, entityName, basePackageName, baseUri, servPackageName, modPackageName);
            Comment comment = (Comment)mirror.getAnnotation(Comment.class);
            if (comment != null) {
                table.setLabel(comment.value());
            } else {
                table.setLabel(entityName);
            }
            tables.put(tableName, table);
            tables.put(entityName, table);
            for (Field field : fields = mirror.getFields()) {
                Annotation[] annotations;
                ColumnDescriptor column = new ColumnDescriptor();
                String fieldName = field.getName();
                if (fieldName.equals("opBy") || fieldName.equals("opAt") || fieldName.equals("delFlag")) continue;
                column.setFieldName(fieldName);
                for (Annotation annotation : annotations = field.getAnnotations()) {
                    if (annotation instanceof Comment) {
                        column.setLabel(((Comment)annotation).value());
                        column.setComment(((Comment)annotation).value());
                    }
                    if (annotation instanceof Id || annotation instanceof Name) {
                        column.primary = true;
                        table.setPkType(column.getSimpleJavaTypeName());
                        column.columnName = fieldName;
                    }
                    if (annotation instanceof ColDefine) {
                        ColType colType = ((ColDefine)annotation).type();
                        column.setColumnType(colType.name());
                        column.dataType = colType.name();
                    }
                    if (!(annotation instanceof Column)) continue;
                    String columnName = ((Column)annotation).value();
                    column.columnName = Strings.isBlank((CharSequence)columnName) ? fieldName : columnName;
                }
                if (Strings.isEmpty((CharSequence)column.getLabel())) {
                    column.setLabel(fieldName);
                }
                table.addColumn(column);
            }
        }
        return tables;
    }
}

