/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.swagger3;

import cn.willingxyz.restdoc.swagger3.IOpenAPIFilter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import java.util.HashSet;

public class HideEmptyControllerOpenAPIFilter
implements IOpenAPIFilter {
    @Override
    public OpenAPI handle(OpenAPI openApi) {
        if (openApi.getPaths() == null) {
            return openApi;
        }
        HashSet tags = new HashSet();
        for (PathItem path : openApi.getPaths().values()) {
            if (path.getGet() != null) {
                tags.addAll(path.getGet().getTags());
            }
            if (path.getPost() != null) {
                tags.addAll(path.getPost().getTags());
            }
            if (path.getPut() != null) {
                tags.addAll(path.getPut().getTags());
            }
            if (path.getDelete() != null) {
                tags.addAll(path.getDelete().getTags());
            }
            if (path.getOptions() != null) {
                tags.addAll(path.getOptions().getTags());
            }
            if (path.getHead() != null) {
                tags.addAll(path.getHead().getTags());
            }
            if (path.getPatch() == null) continue;
            tags.addAll(path.getPatch().getTags());
        }
        openApi.getTags().removeIf(tag -> tags.stream().noneMatch(o -> o.equals(tag.getName())));
        return openApi;
    }
}

