/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.swagger3;

import cn.willingxyz.restdoc.core.models.ControllerModel;
import cn.willingxyz.restdoc.core.models.MappingModel;
import cn.willingxyz.restdoc.core.models.ParameterModel;
import cn.willingxyz.restdoc.core.models.PathModel;
import cn.willingxyz.restdoc.core.models.PropertyModel;
import cn.willingxyz.restdoc.core.models.ResponseModel;
import cn.willingxyz.restdoc.core.models.ReturnModel;
import cn.willingxyz.restdoc.core.models.RootModel;
import cn.willingxyz.restdoc.core.parse.IRestDocGenerator;
import cn.willingxyz.restdoc.core.parse.ITypeInspector;
import cn.willingxyz.restdoc.core.parse.utils.EnumSerializer;
import cn.willingxyz.restdoc.core.parse.utils.FormatUtils;
import cn.willingxyz.restdoc.core.parse.utils.ReflectUtils;
import cn.willingxyz.restdoc.core.parse.utils.TextUtils;
import cn.willingxyz.restdoc.swagger.common.ITypeNameParser;
import cn.willingxyz.restdoc.swagger.common.SwaggerGeneratorConfig;
import cn.willingxyz.restdoc.swagger.common.utils.ClassNameUtils;
import cn.willingxyz.restdoc.swagger.common.utils.StringUtils;
import cn.willingxyz.restdoc.swagger3.IOpenAPIFilter;
import cn.willingxyz.restdoc.swagger3.Swagger3GeneratorConfig;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Swagger3RestDocGenerator
implements IRestDocGenerator {
    public Swagger3GeneratorConfig _config;

    public Swagger3RestDocGenerator(Swagger3GeneratorConfig configuration) {
        this._config = configuration;
    }

    public String generate(RootModel rootModel) {
        OpenAPI openApi = this.generateOpenApi(rootModel);
        if (this._config.isHideEmptyController()) {
            this.hideEmptyController(openApi);
        }
        if (this._config.getOpenAPIFilters() != null) {
            for (IOpenAPIFilter openAPIFilter : this._config.getOpenAPIFilters()) {
                openApi = openAPIFilter.handle(openApi);
            }
        }
        ObjectMapper objectMapper = this.objectMapper();
        try {
            String swaggerJson = objectMapper.writeValueAsString((Object)openApi);
            return swaggerJson;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u9519\u8bef");
        }
    }

    private ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Enum.class, (JsonSerializer)new EnumSerializer());
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    private OpenAPI generateOpenApi(RootModel rootModel) {
        OpenAPI openApi = new OpenAPI();
        this.convertServers(rootModel, openApi);
        this.convertInfo(rootModel, openApi);
        this.convertTag(rootModel, openApi);
        this.convertPath(rootModel, openApi);
        return openApi;
    }

    private void convertServers(RootModel rootModel, OpenAPI openApi) {
        ArrayList<Server> servers = new ArrayList<Server>();
        for (SwaggerGeneratorConfig.ServerInfo server : this._config.getServers()) {
            Server serverInfo = new Server();
            serverInfo.setDescription(server.getDescription());
            serverInfo.setUrl(server.getUrl());
            servers.add(serverInfo);
        }
        openApi.setServers(servers);
    }

    private void convertInfo(RootModel rootModel, OpenAPI openApi) {
        Info info = new Info();
        info.setDescription(this._config.getDescription());
        info.setVersion(this._config.getVersion());
        info.setTitle(this._config.getTitle());
        openApi.setInfo(info);
    }

    private void convertTag(RootModel rootModel, OpenAPI openApi) {
        for (ControllerModel controller : rootModel.getControllers()) {
            Tag tag = new Tag();
            tag.setName(this.getTagName(controller));
            if (!this._config.isResolveJavaDocAsTypeName()) {
                tag.setDescription(controller.getDescription());
            }
            openApi.addTagsItem(tag);
        }
    }

    private void convertPath(RootModel rootModel, OpenAPI openApi) {
        for (ControllerModel controller : rootModel.getControllers()) {
            for (PathModel method : controller.getControllerMethods()) {
                for (MappingModel mapping : method.getMappings()) {
                    this.convertSinglePath(openApi, controller, method, mapping);
                }
            }
        }
    }

    private void convertSinglePath(OpenAPI openApi, ControllerModel controller, PathModel method, MappingModel mapping) {
        Operation operation = new Operation();
        operation.addTagsItem(this.getTagName(controller));
        operation.setSummary(TextUtils.getFirstLine((String)method.getDescription()));
        operation.setDescription(method.getDescription());
        operation.setDeprecated(method.getDeprecated());
        for (ParameterModel param : method.getParameters()) {
            if (param.getLocation() == ParameterModel.ParameterLocation.QUERY) {
                this.convertQueryString(param, openApi).forEach(o -> operation.addParametersItem(o));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.BODY) {
                operation.setRequestBody(this.convertRequestBody(param, openApi));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.PATH) {
                operation.addParametersItem(this.generateSingleParameterSchema("path", param, openApi));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.HEADER) {
                operation.addParametersItem(this.generateSingleParameterSchema("header", param, openApi));
                continue;
            }
            if (param.getLocation() != ParameterModel.ParameterLocation.FILE) continue;
            operation.setRequestBody(this.convertFileParameter(param));
        }
        operation.setResponses(this.convertResponses(method, openApi));
        for (String path : mapping.getPaths()) {
            PathItem pathItem = null;
            if (openApi.getPaths() != null) {
                pathItem = openApi.getPaths().entrySet().stream().filter(o -> ((String)o.getKey()).equals(path)).map(o -> (PathItem)o.getValue()).findFirst().orElse(null);
            }
            if (pathItem == null) {
                pathItem = new PathItem();
            }
            pathItem.setDescription(method.getDescription());
            pathItem.setSummary(TextUtils.getFirstLine((String)method.getDescription()));
            this.setHttpMethod(mapping, pathItem, operation);
            openApi.path(path, pathItem);
        }
    }

    private void setHttpMethod(MappingModel mapping, PathItem pathItem, Operation operation) {
        block10: for (MappingModel.HttpMethod httpMethod : mapping.getHttpMethods()) {
            switch (httpMethod) {
                case GET: {
                    pathItem.get(operation);
                    continue block10;
                }
                case PUT: {
                    pathItem.put(operation);
                    continue block10;
                }
                case POST: {
                    pathItem.post(operation);
                    continue block10;
                }
                case DELETE: {
                    pathItem.delete(operation);
                    continue block10;
                }
                case HEAD: {
                    pathItem.head(operation);
                    continue block10;
                }
                case PATCH: {
                    pathItem.patch(operation);
                    continue block10;
                }
                case TRACE: {
                    pathItem.trace(operation);
                    continue block10;
                }
                case OPTIONS: {
                    pathItem.options(operation);
                }
            }
        }
    }

    private RequestBody convertRequestBody(ParameterModel parameterModel, OpenAPI openAPI) {
        RequestBody requestBody = new RequestBody();
        requestBody.setRequired(Boolean.valueOf(parameterModel.isRequired()));
        requestBody.setDescription(parameterModel.getDescription());
        Schema contentSchema = this.generateSchema(parameterModel.getDescription(), parameterModel.getParameterType(), parameterModel.getChildren(), openAPI);
        requestBody.setContent(this.createContent(contentSchema));
        return requestBody;
    }

    private List<Parameter> convertQueryString(ParameterModel paramModel, OpenAPI openAPI) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (paramModel.getChildren() != null && paramModel.getChildren().size() > 0) {
            this.convertParameterChildren(paramModel.getChildren(), null, openAPI).stream().forEach(o -> parameters.add((Parameter)o));
        } else {
            parameters.add(this.generateSingleParameterSchema("query", paramModel, openAPI));
        }
        return parameters;
    }

    private RequestBody convertFileParameter(ParameterModel param) {
        RequestBody requestBody = new RequestBody();
        Schema propSchema = new Schema();
        propSchema.setType("string");
        propSchema.format("binary");
        Schema schema = new Schema();
        schema.setType("object");
        schema.addProperties(param.getName(), propSchema);
        Content content = new Content();
        MediaType mediaType = new MediaType();
        mediaType.setSchema(schema);
        content.addMediaType("multipart/form-data", mediaType);
        requestBody.setContent(content);
        requestBody.setDescription(param.getDescription());
        requestBody.setRequired(Boolean.valueOf(param.isRequired()));
        return requestBody;
    }

    private ApiResponse convertResponse(ResponseModel responseModel, OpenAPI openAPI) {
        ApiResponse apiResponse = new ApiResponse();
        ReturnModel returnModel = responseModel.getReturnModel();
        apiResponse.setDescription(returnModel.getDescription());
        if (returnModel.getReturnType() == Void.TYPE || returnModel.getReturnType() == Void.class) {
            return apiResponse;
        }
        Schema schema = this.generateSchema(returnModel.getDescription(), returnModel.getReturnType(), returnModel.getChildren(), openAPI);
        apiResponse.setContent(this.createContent(schema));
        return apiResponse;
    }

    private ApiResponses convertResponses(PathModel method, OpenAPI openAPI) {
        ApiResponses response = new ApiResponses();
        for (ResponseModel res : method.getResponse()) {
            ApiResponse apiResponse = this.convertResponse(res, openAPI);
            response.addApiResponse(res.getStatusCode() + "", apiResponse);
        }
        return response;
    }

    private Content createContent(Schema schema) {
        MediaType mediaType = new MediaType();
        mediaType.setSchema(schema);
        Content content = new Content();
        content.addMediaType("application/json", mediaType);
        return content;
    }

    private Parameter generateSingleParameterSchema(String in, ParameterModel paramModel, OpenAPI openAPI) {
        Parameter parameter = new Parameter();
        parameter.setName(paramModel.getName());
        parameter.setDescription(paramModel.getDescription());
        parameter.setIn(in);
        parameter.setRequired(Boolean.valueOf(paramModel.isRequired()));
        Schema schema = this.generateSchema(paramModel.getDescription(), paramModel.getParameterType(), paramModel.getChildren(), openAPI);
        parameter.setSchema(schema);
        parameter.setDescription(StringUtils.combineStr((String)parameter.getDescription(), (String)schema.getDescription()));
        return parameter;
    }

    private List<Parameter> convertParameterChildren(List<PropertyModel> propertyModels, String paraName, OpenAPI openAPI) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String name = "";
        if (paraName != null) {
            name = paraName + ".";
        }
        for (PropertyModel child : propertyModels) {
            if (child.isArray()) {
                this.convertParameterChildren(child.getChildren(), child.getName(), openAPI).stream().forEach(o -> parameters.add((Parameter)o));
                continue;
            }
            if (child.getChildren() == null || child.getChildren().size() == 0) {
                Parameter parameter = new Parameter();
                parameter.setName(name + child.getName());
                parameter.setDescription(child.getDescription());
                parameter.setRequired(Boolean.valueOf(child.isRequired()));
                parameter.setIn("query");
                Schema schema = this.generateSchema(child.getDescription(), child.getPropertyType(), child.getChildren(), openAPI);
                parameter.setSchema(schema);
                parameter.setDescription(StringUtils.combineStr((String)parameter.getDescription(), (String)schema.getDescription()));
                parameters.add(parameter);
                continue;
            }
            parameters.addAll(this.convertParameterChildren(child.getChildren(), name + child.getName(), openAPI));
        }
        return parameters;
    }

    private Schema getOrGenerateComplexSchema(Type type, List<PropertyModel> children, OpenAPI openAPI) {
        String componentName = ClassNameUtils.getComponentName((ITypeInspector)this._config.getTypeInspector(), (ITypeNameParser)this._config.getTypeNameParser(), (Type)type);
        if (openAPI.getComponents() == null) {
            openAPI.components(new Components());
        }
        if (openAPI.getComponents().getSchemas() == null) {
            openAPI.getComponents().schemas(new LinkedHashMap());
        }
        if (!openAPI.getComponents().getSchemas().containsKey(componentName)) {
            Schema schema = this.generateComplexTypeSchema(type, children, openAPI);
            openAPI.getComponents().addSchemas(componentName, schema);
        }
        return (Schema)openAPI.getComponents().getSchemas().get(componentName);
    }

    private Schema generateSchema(String description, Type type, List<PropertyModel> children, OpenAPI openAPI) {
        if (this._config.getTypeInspector().isCollection(type)) {
            return this.generateArraySchema(description, type, children, openAPI);
        }
        if (ReflectUtils.isEnum((Type)type)) {
            return this.generateEnumSchema((Class)type);
        }
        if (children == null || children.isEmpty()) {
            return this.generateSimpleTypeSchema(description, type);
        }
        return this.getOrGenerateComplexSchema(type, children, openAPI);
    }

    private Schema generateArraySchema(String description, Type type, List<PropertyModel> children, OpenAPI openAPI) {
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setDescription(description);
        Schema schema = this.generateSchema(description, this._config.getTypeInspector().getCollectionComponentType(type), children, openAPI);
        arraySchema.setItems(schema);
        arraySchema.setDescription(StringUtils.combineStr((String)arraySchema.getDescription(), (String)schema.getDescription()));
        return arraySchema;
    }

    private Schema generateComplexTypeSchema(Type type, List<PropertyModel> children, OpenAPI openAPI) {
        Schema schema = new Schema();
        ClassJavadoc classDoc = RuntimeJavadoc.getJavadoc((String)type.getTypeName());
        schema.setDescription(FormatUtils.format((Comment)classDoc.getComment()));
        schema.setProperties(this.generateComplexTypeSchemaProperty(type, children, openAPI));
        return schema;
    }

    private Map<String, Schema> generateComplexTypeSchemaProperty(Type type, List<PropertyModel> propertyModels, OpenAPI openAPI) {
        LinkedHashMap<String, Schema> schemas = new LinkedHashMap<String, Schema>();
        for (PropertyModel propertyModel : propertyModels) {
            Schema schema = this.generateSchema(propertyModel.getDescription(), propertyModel.getPropertyType(), propertyModel.getChildren(), openAPI);
            schemas.put(propertyModel.getName(), schema);
        }
        return schemas;
    }

    private Schema generateSimpleTypeSchema(String description, Type type) {
        Schema schema = new Schema();
        schema.setDescription(description);
        schema.setType(this._config.getSwaggerTypeInspector().toSwaggerType(type));
        schema.setFormat(this._config.getSwaggerTypeInspector().toSwaggerFormat(type));
        return schema;
    }

    private Schema generateEnumSchema(Class clazz) {
        ClassJavadoc enumDoc = RuntimeJavadoc.getJavadoc((Class)clazz);
        List enums = Arrays.stream(clazz.getEnumConstants()).map(o -> o.toString()).collect(Collectors.toList());
        Schema itemSchema = new Schema();
        String enumStr = "";
        for (FieldJavadoc enumConst : enumDoc.getEnumConstants()) {
            if (!enumStr.isEmpty()) {
                enumStr = enumStr + ", ";
            }
            enumStr = enumStr + enumConst.getName();
            String desc = FormatUtils.format((Comment)enumConst.getComment());
            if (desc == null || desc.isEmpty()) continue;
            enumStr = enumStr + ": " + desc;
        }
        String desc = FormatUtils.format((Comment)enumDoc.getComment());
        if (desc == null || desc.isEmpty()) {
            itemSchema.setDescription(enumStr);
        } else {
            itemSchema.setDescription(desc + "; " + enumStr);
        }
        itemSchema.setType("string");
        itemSchema.setEnum(enums);
        return itemSchema;
    }

    private String getTagName(ControllerModel controller) {
        if (this._config.isTagDescriptionAsName() && controller.getDescription() != null && !controller.getDescription().isEmpty()) {
            return TextUtils.getFirstLine((String)controller.getDescription());
        }
        return this._config.getTypeNameParser().parse((Type)controller.getControllerClass());
    }

    private void hideEmptyController(OpenAPI openApi) {
        if (openApi.getPaths() == null) {
            return;
        }
        HashSet tags = new HashSet();
        for (PathItem path : openApi.getPaths().values()) {
            if (path.getGet() != null) {
                tags.addAll(path.getGet().getTags());
            }
            if (path.getPost() != null) {
                tags.addAll(path.getPost().getTags());
            }
            if (path.getPut() != null) {
                tags.addAll(path.getPut().getTags());
            }
            if (path.getDelete() != null) {
                tags.addAll(path.getDelete().getTags());
            }
            if (path.getOptions() != null) {
                tags.addAll(path.getOptions().getTags());
            }
            if (path.getHead() != null) {
                tags.addAll(path.getHead().getTags());
            }
            if (path.getPatch() == null) continue;
            tags.addAll(path.getPatch().getTags());
        }
        Iterator iterator = openApi.getTags().iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (tags.stream().filter(o -> o.equals(tag.getName())).findFirst().isPresent()) continue;
            iterator.remove();
        }
    }
}

