/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.swagger3;

import cn.willingxyz.restdoc.core.models.ControllerModel;
import cn.willingxyz.restdoc.core.models.MappingModel;
import cn.willingxyz.restdoc.core.models.ParameterModel;
import cn.willingxyz.restdoc.core.models.PathModel;
import cn.willingxyz.restdoc.core.models.PropertyModel;
import cn.willingxyz.restdoc.core.models.ResponseModel;
import cn.willingxyz.restdoc.core.models.ReturnModel;
import cn.willingxyz.restdoc.core.models.RootModel;
import cn.willingxyz.restdoc.core.parse.IRestDocGenerator;
import cn.willingxyz.restdoc.core.parse.utils.FormatUtils;
import cn.willingxyz.restdoc.core.parse.utils.ReflectUtils;
import cn.willingxyz.restdoc.core.parse.utils.TextUtils;
import cn.willingxyz.restdoc.swagger3.Swagger3GeneratorConfig;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Swagger3RestDocGenerator
implements IRestDocGenerator {
    public Swagger3GeneratorConfig _configuration;

    public Swagger3RestDocGenerator(Swagger3GeneratorConfig configuration) {
        this._configuration = configuration;
    }

    public String generate(RootModel rootModel) {
        OpenAPI openApi = this.generateOpenApi(rootModel);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            String swaggerJson = objectMapper.writeValueAsString((Object)openApi);
            return swaggerJson;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u9519\u8bef");
        }
    }

    private OpenAPI generateOpenApi(RootModel rootModel) {
        OpenAPI openApi = new OpenAPI();
        this.convertServers(rootModel, openApi);
        this.convertInfo(rootModel, openApi);
        this.convertTag(rootModel, openApi);
        this.convertPath(rootModel, openApi);
        return openApi;
    }

    private void convertServers(RootModel rootModel, OpenAPI openApi) {
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Swagger3GeneratorConfig.ServerInfo server : this._configuration.getServers()) {
            Server serverInfo = new Server();
            serverInfo.setDescription(server.getDescription());
            serverInfo.setUrl(server.getUrl());
            servers.add(serverInfo);
        }
        openApi.setServers(servers);
    }

    private void convertInfo(RootModel rootModel, OpenAPI openApi) {
        Info info = new Info();
        info.setDescription(this._configuration.getDescription());
        info.setVersion(this._configuration.getVersion());
        info.setTitle(this._configuration.getTitle());
        openApi.setInfo(info);
    }

    private void convertTag(RootModel rootModel, OpenAPI openApi) {
        for (ControllerModel controller : rootModel.getControllers()) {
            Tag tag = new Tag();
            tag.setName(this._configuration.getTypeNameParser().parse((Type)controller.getControllerClass()));
            tag.setDescription(controller.getDescription());
            openApi.addTagsItem(tag);
        }
    }

    private void convertPath(RootModel rootModel, OpenAPI openApi) {
        for (ControllerModel controller : rootModel.getControllers()) {
            for (PathModel method : controller.getControllerMethods()) {
                for (MappingModel mapping : method.getMappings()) {
                    this.convertSinglePath(openApi, controller, method, mapping);
                }
            }
        }
    }

    private void convertSinglePath(OpenAPI openApi, ControllerModel controller, PathModel method, MappingModel mapping) {
        PathItem pathItem = new PathItem();
        pathItem.setDescription(method.getDescription());
        pathItem.setSummary(TextUtils.getFirstLine((String)method.getDescription()));
        Operation operation = new Operation();
        operation.addTagsItem(this._configuration.getTypeNameParser().parse((Type)controller.getControllerClass()));
        operation.setSummary(TextUtils.getFirstLine((String)method.getDescription()));
        operation.setDescription(method.getDescription());
        operation.setDeprecated(method.getDeprecated());
        for (ParameterModel param : method.getParameters()) {
            if (param.getLocation() == ParameterModel.ParameterLocation.QUERY) {
                this.convertQueryString(param, openApi).forEach(o -> operation.addParametersItem(o));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.BODY) {
                operation.setRequestBody(this.convertRequestBody(param, openApi));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.PATH) {
                operation.addParametersItem(this.convertPathParameter(param));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.HEADER) {
                operation.addParametersItem(this.convertHeaderParameter(param));
                continue;
            }
            if (param.getLocation() != ParameterModel.ParameterLocation.FILE) continue;
            operation.setRequestBody(this.convertFileParameter(param));
        }
        operation.setResponses(this.convertResponses(method, openApi));
        this.setHttpMethod(mapping, pathItem, operation);
        for (String path : mapping.getPaths()) {
            openApi.path(path, pathItem);
        }
    }

    private void setHttpMethod(MappingModel mapping, PathItem pathItem, Operation operation) {
        block10: for (MappingModel.HttpMethod httpMethod : mapping.getHttpMethods()) {
            switch (httpMethod) {
                case GET: {
                    pathItem.get(operation);
                    continue block10;
                }
                case PUT: {
                    pathItem.put(operation);
                    continue block10;
                }
                case POST: {
                    pathItem.post(operation);
                    continue block10;
                }
                case DELETE: {
                    pathItem.delete(operation);
                    continue block10;
                }
                case HEAD: {
                    pathItem.head(operation);
                    continue block10;
                }
                case PATCH: {
                    pathItem.patch(operation);
                    continue block10;
                }
                case TRACE: {
                    pathItem.patch(operation);
                    continue block10;
                }
                case OPTIONS: {
                    pathItem.options(operation);
                }
            }
        }
    }

    private RequestBody convertRequestBody(ParameterModel parameterModel, OpenAPI openAPI) {
        RequestBody requestBody = new RequestBody();
        if (parameterModel.isArray()) {
            if (parameterModel.getChildren() == null || parameterModel.getChildren().isEmpty()) {
                ArraySchema arraySchema = new ArraySchema();
                Schema itemSchema = new Schema();
                itemSchema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(this._configuration.getTypeInspector().getCollectionComponentType(parameterModel.getParameterType())));
                arraySchema.setItems(itemSchema);
                Content content = this.createContent((Schema)arraySchema);
                requestBody.setContent(content);
                requestBody.setRequired(Boolean.valueOf(parameterModel.isRequired()));
                requestBody.setDescription(parameterModel.getDescription());
            } else {
                Schema itemSchema = new Schema();
                itemSchema.set$ref("#/components/schemas/" + this.putSchemaComponent(parameterModel.getParameterType(), parameterModel.getChildren(), openAPI));
                Content content = this.createContent(itemSchema);
                requestBody.setContent(content);
                requestBody.setRequired(Boolean.valueOf(parameterModel.isRequired()));
                requestBody.setDescription(parameterModel.getDescription());
            }
        } else if (parameterModel.getChildren() == null || parameterModel.getChildren().size() == 0) {
            Schema schema = null;
            if (ReflectUtils.isEnum((Type)parameterModel.getParameterType())) {
                Class clazz = (Class)parameterModel.getParameterType();
                ArraySchema arraySchema = new ArraySchema();
                ClassJavadoc enumDoc = RuntimeJavadoc.getJavadoc((Class)clazz);
                arraySchema.setDescription(FormatUtils.format((Comment)enumDoc.getComment()));
                Schema itemSchema = new Schema();
                itemSchema.setType("string");
                List enums = Arrays.stream(clazz.getEnumConstants()).map(o -> o.toString()).collect(Collectors.toList());
                itemSchema.setEnum(enums);
                arraySchema.setItems(itemSchema);
                if (enums.size() > 0) {
                    itemSchema.setDefault(enums.get(0));
                }
                schema = arraySchema;
                schema.setDescription(parameterModel.getDescription());
                if (parameterModel.isRequired()) {
                    schema.setRequired(Arrays.asList(parameterModel.getName()));
                }
            } else {
                schema = new Schema();
                schema.setDescription(parameterModel.getDescription());
                schema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(parameterModel.getParameterType()));
                schema.setFormat(this._configuration.getSwaggerTypeInspector().toSwaggerFormat(parameterModel.getParameterType()));
                if (parameterModel.isRequired()) {
                    schema.setRequired(Arrays.asList(parameterModel.getName()));
                }
            }
            Content content = this.createContent(schema);
            requestBody.setContent(content);
        } else {
            Schema schema = new Schema();
            MediaType mediaType = new MediaType();
            mediaType.setSchema(schema);
            Content content = new Content();
            content.addMediaType("application/json", mediaType);
            requestBody.setContent(content);
            requestBody.setRequired(Boolean.valueOf(parameterModel.isRequired()));
            requestBody.setDescription(parameterModel.getDescription());
            schema.set$ref("#/components/schemas/" + this.putSchemaComponent(parameterModel.getParameterType(), parameterModel.getChildren(), openAPI));
        }
        return requestBody;
    }

    private List<Parameter> convertQueryString(ParameterModel paramModel, OpenAPI openAPI) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (paramModel.isArray()) {
            if (paramModel.getChildren().size() == 0) {
                this.addSimpleQueryParameterSchema(paramModel, parameters);
            } else {
                Parameter parameter = new Parameter();
                parameter.setName(paramModel.getName());
                parameter.setDescription(paramModel.getDescription());
                parameter.setIn("query");
                ArraySchema arraySchema = new ArraySchema();
                arraySchema.setType("array");
                Schema schema = new Schema();
                schema.set$ref(this.putSchemaComponent(paramModel.getParameterType(), paramModel.getChildren(), openAPI));
                arraySchema.setItems(schema);
                parameter.setSchema((Schema)arraySchema);
                parameters.add(parameter);
            }
        } else if (paramModel.getChildren() == null || paramModel.getChildren().size() == 0) {
            this.addSimpleQueryParameterSchema(paramModel, parameters);
        } else {
            this.convertParameterChildren(paramModel.getChildren(), null, paramModel.getDescription(), paramModel.isRequired(), false).stream().forEach(o -> parameters.add((Parameter)o));
        }
        return parameters;
    }

    private Parameter convertPathParameter(ParameterModel param) {
        Parameter parameter = new Parameter();
        parameter.setIn("path");
        parameter.setName(param.getName());
        parameter.setDescription(param.getDescription());
        parameter.setSchema(this.generateSimpleParameterSchema(param));
        return parameter;
    }

    private Parameter convertHeaderParameter(ParameterModel paramModel) {
        Parameter parameter = new Parameter();
        parameter.setIn("header");
        parameter.setName(paramModel.getName());
        parameter.setDescription(paramModel.getDescription());
        parameter.setSchema(this.generateSimpleParameterSchema(paramModel));
        return parameter;
    }

    private RequestBody convertFileParameter(ParameterModel param) {
        RequestBody requestBody = new RequestBody();
        Schema propSchema = new Schema();
        propSchema.setType("string");
        propSchema.format("binary");
        Schema schema = new Schema();
        schema.setType("object");
        schema.addProperties(param.getName(), propSchema);
        Content content = new Content();
        MediaType mediaType = new MediaType();
        mediaType.setSchema(schema);
        content.addMediaType("multipart/form-data", mediaType);
        requestBody.setContent(content);
        requestBody.setDescription(param.getDescription());
        requestBody.setRequired(Boolean.valueOf(param.isRequired()));
        return requestBody;
    }

    private ApiResponse convertResponse(ResponseModel responseModel, OpenAPI openAPI) {
        ApiResponse apiResponse = new ApiResponse();
        ReturnModel returnModel = responseModel.getReturnModel();
        apiResponse.setDescription(returnModel.getDescription());
        if (returnModel.getReturnType() == Void.TYPE || returnModel.getReturnType() == Void.class) {
            return apiResponse;
        }
        if (returnModel.isArray()) {
            if (returnModel.getChildren() == null || returnModel.getChildren().isEmpty()) {
                Schema schema = this.generateSimpleArraySchema(returnModel);
                apiResponse.setContent(this.createContent(schema));
            } else {
                Schema itemSchema = new Schema();
                itemSchema.setDescription(returnModel.getDescription());
                itemSchema.set$ref("#/components/schemas/" + this.putSchemaComponent(returnModel.getReturnType(), returnModel.getChildren(), openAPI));
                Content content = this.createContent(itemSchema);
                apiResponse.setContent(content);
            }
        } else if (returnModel.getChildren() != null && returnModel.getChildren().size() > 0) {
            Schema schema = new Schema();
            Content content = this.createContent(schema);
            apiResponse.setContent(content);
            schema.set$ref("#/components/schemas/" + this.putSchemaComponent(returnModel.getReturnType(), returnModel.getChildren(), openAPI));
        } else {
            Schema schema = new Schema();
            if (ReflectUtils.isEnum((Type)returnModel.getReturnType())) {
                schema = this.generateEnumSchema((Class)returnModel.getReturnType());
            } else {
                schema.setDescription(returnModel.getDescription());
                schema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(returnModel.getReturnType()));
                schema.setFormat(this._configuration.getSwaggerTypeInspector().toSwaggerFormat(returnModel.getReturnType()));
            }
            Content content = this.createContent(schema);
            apiResponse.setContent(content);
            apiResponse.setDescription(returnModel.getDescription());
        }
        return apiResponse;
    }

    private String putSchemaComponent(Type type, List<PropertyModel> children, OpenAPI openAPI) {
        String className = this.getComponentName(type);
        if (openAPI.getComponents() == null) {
            openAPI.components(new Components());
        }
        if (openAPI.getComponents().getSchemas() == null) {
            openAPI.getComponents().schemas(new HashMap());
        }
        if (openAPI.getComponents().getSchemas().containsKey(className)) {
            return className;
        }
        Schema schema = this.generateSchemaComponent(type, children, openAPI);
        openAPI.getComponents().addSchemas(className, schema);
        return className;
    }

    private String getComponentName(Type type) {
        int dotIndex;
        int collectionCount = 0;
        while (this._configuration.getTypeInspector().isCollection(type)) {
            ++collectionCount;
            type = this._configuration.getTypeInspector().getCollectionComponentType(type);
        }
        String name = this._configuration.getTypeNameParser().parse(type);
        int $index = name.lastIndexOf(36);
        if ($index > (dotIndex = name.lastIndexOf(46))) {
            return this.convertCollectionName(collectionCount, name, '$');
        }
        return this.convertCollectionName(collectionCount, name, ',');
    }

    private String convertCollectionName(int collectionCount, String name, char ch) {
        String prefix = "";
        int index = name.lastIndexOf(ch);
        if (index != -1) {
            prefix = name.substring(0, index + 1);
            name = name.substring(index + 1);
        }
        while (collectionCount-- > 0) {
            name = "[" + name;
        }
        return prefix + name;
    }

    private Schema generateSchemaComponent(Type type, List<PropertyModel> children, OpenAPI openAPI) {
        if (this._configuration.getTypeInspector().isCollection(type)) {
            ArraySchema arraySchema = new ArraySchema();
            arraySchema.setItems(this.generateSchemaComponent(this._configuration.getTypeInspector().getCollectionComponentType(type), children, openAPI));
            return arraySchema;
        }
        if (ReflectUtils.isEnum((Type)type)) {
            return this.generateEnumSchema((Class)type);
        }
        Schema schema = new Schema();
        String className = this._configuration.getTypeNameParser().parse(type);
        schema.setName(className);
        schema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(type));
        ClassJavadoc classDoc = RuntimeJavadoc.getJavadoc((String)type.getTypeName());
        schema.setDescription(FormatUtils.format((Comment)classDoc.getComment()));
        schema.setProperties(this.generateSchemaProperty(children, openAPI));
        return schema;
    }

    private Map<String, Schema> generateSchemaProperty(List<PropertyModel> propertyModels, OpenAPI openAPI) {
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        for (PropertyModel propertyModel : propertyModels) {
            Schema schema = new Schema();
            if (this._configuration.getTypeInspector().isCollection(propertyModel.getPropertyType())) {
                ArraySchema arraySchema = new ArraySchema();
                arraySchema.setItems(this.generateSchemaComponent(this._configuration.getTypeInspector().getCollectionComponentType(propertyModel.getPropertyType()), propertyModel.getChildren(), openAPI));
                schema = arraySchema;
            } else if (ReflectUtils.isEnum((Type)propertyModel.getPropertyType())) {
                schema = this.generateEnumSchema((Class)propertyModel.getPropertyType());
            } else if (propertyModel.getChildren() == null || propertyModel.getChildren().size() == 0) {
                schema.setDescription(propertyModel.getDescription());
                if (ReflectUtils.isEnum((Type)propertyModel.getPropertyType())) {
                    Class clazz = (Class)propertyModel.getPropertyType();
                    schema = this.generateEnumSchema(clazz);
                } else {
                    schema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(propertyModel.getPropertyType()));
                    schema.setFormat(this._configuration.getSwaggerTypeInspector().toSwaggerFormat(propertyModel.getPropertyType()));
                }
                if (propertyModel.getRequired() != null && propertyModel.getRequired().booleanValue()) {
                    schema.setRequired(Arrays.asList(propertyModel.getName()));
                }
            } else {
                schema.set$ref("#/components/schemas/" + this.putSchemaComponent(propertyModel.getPropertyType(), propertyModel.getChildren(), openAPI));
            }
            schemas.put(propertyModel.getName(), schema);
        }
        return schemas;
    }

    private ArraySchema generateEnumSchema(Class clazz) {
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setType("string");
        ClassJavadoc enumDoc = RuntimeJavadoc.getJavadoc((Class)clazz);
        arraySchema.setDescription(FormatUtils.format((Comment)enumDoc.getComment()));
        List enums = Arrays.stream(clazz.getEnumConstants()).map(o -> o.toString()).collect(Collectors.toList());
        Schema itemSchema = new Schema();
        itemSchema.setType("string");
        itemSchema.setEnum(enums);
        if (enums.size() > 0) {
            itemSchema.setDefault(enums.get(0));
        }
        arraySchema.setItems(itemSchema);
        return arraySchema;
    }

    private ApiResponses convertResponses(PathModel method, OpenAPI openAPI) {
        ApiResponses response = new ApiResponses();
        for (ResponseModel res : method.getResponse()) {
            ApiResponse apiResponse = this.convertResponse(res, openAPI);
            response.addApiResponse(res.getStatusCode() + "", apiResponse);
        }
        return response;
    }

    private Schema generateSimpleArraySchema(ReturnModel returnModel) {
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setDescription(returnModel.getDescription());
        Schema itemSchema = new Schema();
        itemSchema.setDescription(returnModel.getDescription());
        if (ReflectUtils.isEnum((Type)this._configuration.getTypeInspector().getCollectionComponentType(returnModel.getReturnType()))) {
            itemSchema = this.generateEnumSchema((Class)this._configuration.getTypeInspector().getCollectionComponentType(returnModel.getReturnType()));
        } else {
            itemSchema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(this._configuration.getTypeInspector().getCollectionComponentType(returnModel.getReturnType())));
            itemSchema.setFormat(this._configuration.getSwaggerTypeInspector().toSwaggerFormat(returnModel.getReturnType()));
        }
        arraySchema.setItems(itemSchema);
        return arraySchema;
    }

    private Content createContent(Schema schema) {
        MediaType mediaType = new MediaType();
        mediaType.setSchema(schema);
        Content content = new Content();
        content.addMediaType("application/json", mediaType);
        return content;
    }

    private void addSimpleQueryParameterSchema(ParameterModel paramModel, ArrayList<Parameter> parameters) {
        Parameter parameter = new Parameter();
        parameter.setName(paramModel.getName());
        parameter.setDescription(paramModel.getDescription());
        parameter.setIn("query");
        parameter.setSchema(this.generateSimpleParameterSchema(paramModel));
        parameters.add(parameter);
    }

    private Schema generateSimpleParameterSchema(ParameterModel paramModel) {
        if (ReflectUtils.isEnum((Type)paramModel.getParameterType())) {
            return this.generateEnumSchema((Class)paramModel.getParameterType());
        }
        if (this._configuration.getTypeInspector().isCollection(paramModel.getParameterType())) {
            return this.generateArraySchema(paramModel);
        }
        Schema schema = new Schema();
        schema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(paramModel.getParameterType()));
        schema.setFormat(this._configuration.getSwaggerTypeInspector().toSwaggerFormat(paramModel.getParameterType()));
        return schema;
    }

    private Schema generateArraySchema(ParameterModel paramModel) {
        ArraySchema arraySchema = new ArraySchema();
        Schema schema = new Schema();
        schema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(this._configuration.getTypeInspector().getCollectionComponentType(paramModel.getParameterType())));
        schema.setFormat(this._configuration.getSwaggerTypeInspector().toSwaggerFormat(paramModel.getParameterType()));
        arraySchema.setItems(schema);
        return arraySchema;
    }

    private Schema generateSimpleParameterSchema(PropertyModel child) {
        if (ReflectUtils.isEnum((Type)child.getPropertyType())) {
            return this.generateEnumSchema((Class)child.getPropertyType());
        }
        if (this._configuration.getTypeInspector().isCollection(child.getPropertyType())) {
            return this.generateArraySchema(child);
        }
        Schema schema = new Schema();
        schema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(child.getPropertyType()));
        schema.setFormat(this._configuration.getSwaggerTypeInspector().toSwaggerFormat(child.getPropertyType()));
        return schema;
    }

    private List<Parameter> convertParameterChildren(List<PropertyModel> propertyModels, String paraName, String desc, Boolean required, boolean isArray) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String name = "";
        if (paraName != null) {
            name = paraName + ".";
        }
        for (PropertyModel child : propertyModels) {
            if (child.isArray() || child.getChildren() != null && child.getChildren().size() != 0) continue;
            Parameter parameter = new Parameter();
            parameter.setName(name + child.getName());
            parameter.setDescription(child.getDescription());
            parameter.setIn("query");
            if (isArray) {
                parameter.setSchema(this.generateArraySchema(child));
            } else {
                parameter.setSchema(this.generateSimpleParameterSchema(child));
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    private Schema generateArraySchema(PropertyModel child) {
        ArraySchema arraySchema = new ArraySchema();
        Schema schema = new Schema();
        schema.setType(this._configuration.getSwaggerTypeInspector().toSwaggerType(child.getPropertyType()));
        schema.setFormat(this._configuration.getSwaggerTypeInspector().toSwaggerFormat(child.getPropertyType()));
        arraySchema.setItems(schema);
        return arraySchema;
    }
}

