/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.swagger3;

import cn.willingxyz.restdoc.swagger3.ISwaggerTypeInspector;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PrimitiveSwaggerTypeInspector
implements ISwaggerTypeInspector {
    private Map<Type, Item> _classes;
    private Item[] _items = new Item[]{new Item((Type)((Object)Integer.class), "integer", "int32"), new Item(Integer.TYPE, "integer", "int32"), new Item((Type)((Object)Long.class), "integer", "int64"), new Item(Long.TYPE, "integer", "int64"), new Item((Type)((Object)Float.class), "number", "float"), new Item(Float.TYPE, "number", "float"), new Item((Type)((Object)Double.class), "number", "double"), new Item(Double.TYPE, "number", "double"), new Item((Type)((Object)String.class), "string", null), new Item((Type)((Object)String[].class), "array", null), new Item(Byte.TYPE, "string", "byte"), new Item((Type)((Object)Byte.class), "string", "byte"), new Item((Type)((Object)byte[].class), "string", "binary"), new Item((Type)((Object)Byte[].class), "string", "binary"), new Item(Boolean.TYPE, "boolean", null), new Item((Type)((Object)Boolean.class), "boolean", null), new Item((Type)((Object)Enum.class), "object", null), new Item((Type)((Object)List.class), "array", null), new Item((Type)((Object)Object[].class), "array", null), new Item((Type)((Object)Date.class), "string", "date-time"), new Item((Type)((Object)LocalDate.class), "string", "date"), new Item((Type)((Object)LocalTime.class), "string", null), new Item((Type)((Object)LocalDateTime.class), "string", "date-time"), new Item((Type)((Object)Year.class), "integer", "int32"), new Item((Type)((Object)YearMonth.class), "string", null), new Item((Type)((Object)MonthDay.class), "string", null), new Item((Type)((Object)Instant.class), "integer", "int64")};

    public PrimitiveSwaggerTypeInspector() {
        this._classes = Arrays.stream(this._items).collect(Collectors.toMap(o -> o.getType(), p -> p));
    }

    @Override
    public String toSwaggerType(Type type) {
        if (!this._classes.containsKey(type)) {
            return "object";
        }
        return this._classes.get(type).getSwaggerType();
    }

    @Override
    public String toSwaggerFormat(Type type) {
        if (!this._classes.containsKey(type)) {
            return null;
        }
        return this._classes.get(type).getSwaggerFormat();
    }

    private static class Item {
        private Type _type;
        private String _swaggerType;
        private String _swaggerFormat;

        public Item(Type type, String swaggerType, String swaggerFormat) {
            this._type = type;
            this._swaggerType = swaggerType;
            this._swaggerFormat = swaggerFormat;
        }

        public Type getType() {
            return this._type;
        }

        public String getSwaggerType() {
            return this._swaggerType;
        }

        public String getSwaggerFormat() {
            return this._swaggerFormat;
        }

        public void setType(Type _type) {
            this._type = _type;
        }

        public void setSwaggerType(String _swaggerType) {
            this._swaggerType = _swaggerType;
        }

        public void setSwaggerFormat(String _swaggerFormat) {
            this._swaggerFormat = _swaggerFormat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Type this$_type = this.getType();
            Type other$_type = other.getType();
            if (this$_type == null ? other$_type != null : !this$_type.equals(other$_type)) {
                return false;
            }
            String this$_swaggerType = this.getSwaggerType();
            String other$_swaggerType = other.getSwaggerType();
            if (this$_swaggerType == null ? other$_swaggerType != null : !this$_swaggerType.equals(other$_swaggerType)) {
                return false;
            }
            String this$_swaggerFormat = this.getSwaggerFormat();
            String other$_swaggerFormat = other.getSwaggerFormat();
            return !(this$_swaggerFormat == null ? other$_swaggerFormat != null : !this$_swaggerFormat.equals(other$_swaggerFormat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $_type = this.getType();
            result = result * 59 + ($_type == null ? 43 : $_type.hashCode());
            String $_swaggerType = this.getSwaggerType();
            result = result * 59 + ($_swaggerType == null ? 43 : $_swaggerType.hashCode());
            String $_swaggerFormat = this.getSwaggerFormat();
            result = result * 59 + ($_swaggerFormat == null ? 43 : $_swaggerFormat.hashCode());
            return result;
        }

        public String toString() {
            return "PrimitiveSwaggerTypeInspector.Item(_type=" + this.getType() + ", _swaggerType=" + this.getSwaggerType() + ", _swaggerFormat=" + this.getSwaggerFormat() + ")";
        }
    }
}

