/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.swagger2;

import cn.willingxyz.restdoc.core.models.ControllerModel;
import cn.willingxyz.restdoc.core.models.MappingModel;
import cn.willingxyz.restdoc.core.models.ParameterModel;
import cn.willingxyz.restdoc.core.models.PathModel;
import cn.willingxyz.restdoc.core.models.PropertyModel;
import cn.willingxyz.restdoc.core.models.ResponseModel;
import cn.willingxyz.restdoc.core.models.ReturnModel;
import cn.willingxyz.restdoc.core.models.RootModel;
import cn.willingxyz.restdoc.core.parse.IRestDocGenerator;
import cn.willingxyz.restdoc.core.parse.ITypeInspector;
import cn.willingxyz.restdoc.core.parse.utils.FormatUtils;
import cn.willingxyz.restdoc.core.parse.utils.TextUtils;
import cn.willingxyz.restdoc.swagger.common.ITypeNameParser;
import cn.willingxyz.restdoc.swagger.common.SwaggerGeneratorConfig;
import cn.willingxyz.restdoc.swagger.common.utils.ClassNameUtils;
import cn.willingxyz.restdoc.swagger.common.utils.JsonUtils;
import cn.willingxyz.restdoc.swagger.common.utils.StringUtils;
import cn.willingxyz.restdoc.swagger2.GenericParameter;
import cn.willingxyz.restdoc.swagger2.ISwaggerFilter;
import cn.willingxyz.restdoc.swagger2.Swagger2GeneratorConfig;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import io.swagger.models.ArrayModel;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Swagger2RestDocGenerator
implements IRestDocGenerator {
    private static Logger logger = LoggerFactory.getLogger(Swagger2RestDocGenerator.class);
    private final Swagger2GeneratorConfig _config;

    public Swagger2RestDocGenerator(Swagger2GeneratorConfig config) {
        this._config = config;
    }

    public String generate(RootModel rootModel) {
        Swagger swagger = this.generateSwagger(rootModel);
        if (this._config.getSwaggerFilters() != null) {
            for (ISwaggerFilter openAPIFilter : this._config.getSwaggerFilters()) {
                swagger = openAPIFilter.handle(swagger);
            }
        }
        ObjectMapper objectMapper = JsonUtils.objectMapper();
        try {
            return objectMapper.writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u9519\u8bef");
        }
    }

    private Swagger generateSwagger(RootModel rootModel) {
        Swagger swagger = new Swagger();
        this.convertServers(rootModel, swagger);
        this.convertInfo(rootModel, swagger);
        this.convertTag(rootModel, swagger);
        this.convertPath(rootModel, swagger);
        return swagger;
    }

    private void convertTag(RootModel rootModel, Swagger swagger) {
        for (ControllerModel controller : rootModel.getControllers()) {
            Tag tag = new Tag();
            tag.setName(this.getTagName(controller));
            tag.setDescription(controller.getDescription());
            swagger.addTag(tag);
        }
    }

    private void convertInfo(RootModel rootModel, Swagger swagger) {
        Info info = new Info();
        info.setDescription(this._config.getDescription());
        info.setVersion(this._config.getVersion());
        info.setTitle(this._config.getTitle());
        swagger.setInfo(info);
    }

    private void convertServers(RootModel rootModel, Swagger swagger) {
        if (this._config.getServers() == null || this._config.getServers().isEmpty()) {
            return;
        }
        String url = ((SwaggerGeneratorConfig.ServerInfo)this._config.getServers().get(0)).getUrl();
        if (!(url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ws://") || url.startsWith("wss://"))) {
            url = "http://" + url;
        }
        try {
            URL urlObj = new URL(url);
            if (urlObj.getPort() == -1) {
                swagger.setHost(urlObj.getHost());
            } else {
                swagger.setHost(urlObj.getHost() + ":" + urlObj.getPort());
            }
            swagger.setBasePath(urlObj.getPath());
        }
        catch (MalformedURLException e) {
            logger.warn("invalid server url: " + url);
        }
        this._config.getServers().forEach(o -> {
            try {
                URL urlObj = new URL(o.getUrl());
                Scheme scheme = Scheme.forValue((String)urlObj.getProtocol());
                if (scheme != null) {
                    if (swagger.getSchemes() == null) {
                        swagger.setSchemes(new ArrayList());
                    }
                    swagger.getSchemes().add(scheme);
                }
            }
            catch (MalformedURLException e) {
                logger.warn("invalid server url: " + o.getUrl());
            }
        });
    }

    private void convertPath(RootModel rootModel, Swagger swagger) {
        for (ControllerModel controller : rootModel.getControllers()) {
            for (PathModel method : controller.getControllerMethods()) {
                for (MappingModel mapping : method.getMappings()) {
                    this.convertSinglePath(swagger, controller, method, mapping);
                }
            }
        }
    }

    private void convertSinglePath(Swagger swagger, ControllerModel controller, PathModel method, MappingModel mapping) {
        Operation operation = new Operation();
        operation.addTag(this.getTagName(controller));
        operation.setSummary(TextUtils.getFirstLine((String)method.getDescription()));
        operation.setDescription(method.getDescription());
        operation.setDeprecated(method.getDeprecated());
        for (ParameterModel param : method.getParameters()) {
            this.convertParameter(swagger, operation, param);
        }
        operation.setResponses(this.convertResponses(method, swagger));
        for (String pathItem : mapping.getPaths()) {
            Path path = null;
            if (swagger.getPaths() != null) {
                path = swagger.getPaths().entrySet().stream().filter(o -> ((String)o.getKey()).equals(pathItem)).map(o -> (Path)o.getValue()).findFirst().orElse(null);
            }
            if (path == null) {
                path = new Path();
            }
            this.setHttpMethod(mapping, path, operation);
            swagger.path(pathItem, path);
        }
    }

    private void convertParameter(Swagger swagger, Operation operation, ParameterModel param) {
        if (param.getLocation() == ParameterModel.ParameterLocation.QUERY) {
            this.convertQueryString(param, swagger).forEach(o -> operation.addParameter(o));
        } else if (param.getLocation() == ParameterModel.ParameterLocation.BODY) {
            operation.addParameter(this.convertRequestBody(param, swagger));
        } else if (param.getLocation() == ParameterModel.ParameterLocation.PATH) {
            operation.addParameter(this.generateSingleParameterSchema("path", param, swagger));
        } else if (param.getLocation() == ParameterModel.ParameterLocation.HEADER) {
            operation.addParameter(this.generateSingleParameterSchema("header", param, swagger));
        } else if (param.getLocation() == ParameterModel.ParameterLocation.FILE) {
            operation.consumes("multipart/form-data");
            operation.addParameter(this.convertFileParameter(param));
        }
    }

    private Map<String, Response> convertResponses(PathModel method, Swagger swagger) {
        LinkedHashMap<String, Response> responses = new LinkedHashMap<String, Response>();
        for (ResponseModel res : method.getResponse()) {
            Response apiResponse = this.convertResponse(res, swagger);
            responses.put(res.getStatusCode() + "", apiResponse);
        }
        return responses;
    }

    private Response convertResponse(ResponseModel responseModel, Swagger swagger) {
        Response apiResponse = new Response();
        ReturnModel returnModel = responseModel.getReturnModel();
        apiResponse.setDescription(returnModel.getDescription());
        if (returnModel.getReturnType() == Void.TYPE || returnModel.getReturnType() == Void.class) {
            return apiResponse;
        }
        apiResponse.setResponseSchema(this.getOrGenerateModel(returnModel.getEnums(), false, returnModel.getExample(), returnModel.getDescription(), returnModel.getReturnType(), returnModel.getChildren(), swagger));
        Property property = this.generateProperty(returnModel.getEnums(), false, returnModel.getExample(), returnModel.getDescription(), returnModel.getReturnType(), returnModel.getChildren(), swagger);
        apiResponse.setSchema(property);
        apiResponse.setDescription(StringUtils.combineStr((String)apiResponse.getDescription(), (String)property.getDescription()));
        return apiResponse;
    }

    private Parameter convertFileParameter(ParameterModel param) {
        FormParameter formDataParameter = new FormParameter();
        formDataParameter.setType("file");
        formDataParameter.setName(param.getName());
        formDataParameter.setDescription(param.getDescription());
        formDataParameter.setExample(param.getExample());
        formDataParameter.setRequired(param.isRequired());
        return formDataParameter;
    }

    private Parameter convertRequestBody(ParameterModel parameterModel, Swagger swagger) {
        BodyParameter bodyParameter = new BodyParameter();
        bodyParameter.setName(parameterModel.getName());
        bodyParameter.setDescription(parameterModel.getDescription());
        bodyParameter.setRequired(parameterModel.isRequired());
        Model model = this.getOrGenerateModel(parameterModel.getEnums(), parameterModel.isRequired(), parameterModel.getExample(), parameterModel.getDescription(), parameterModel.getParameterType(), parameterModel.getChildren(), swagger);
        bodyParameter.setSchema(model);
        return bodyParameter;
    }

    private Model getOrGenerateModel(List<String> enums, boolean required, String example, String description, Type parameterType, List<PropertyModel> children, Swagger swagger) {
        String componentName = ClassNameUtils.getComponentName((ITypeInspector)this._config.getTypeInspector(), (ITypeNameParser)this._config.getTypeNameParser(), (Type)parameterType);
        if (swagger.getDefinitions() == null) {
            swagger.setDefinitions(new LinkedHashMap());
        }
        if (!swagger.getDefinitions().containsKey(componentName)) {
            Property property = this.generateProperty(enums, required, example, description, parameterType, children, swagger);
            ModelImpl model = null;
            if (property instanceof ObjectProperty) {
                model = new ModelImpl();
                model.setProperties(((ObjectProperty)property).getProperties());
            } else if (property instanceof ArrayProperty) {
                ArrayModel arrayModel = new ArrayModel();
                arrayModel.setItems(property);
                model = arrayModel;
            } else {
                ModelImpl modelImpl = new ModelImpl();
                modelImpl.setName(property.getName());
                modelImpl.setDescription(property.getDescription());
                modelImpl.setTitle(property.getTitle());
                modelImpl.setType(property.getType());
                modelImpl.setFormat(property.getFormat());
                if (property instanceof StringProperty) {
                    modelImpl.setEnum(((StringProperty)property).getEnum());
                    modelImpl.setDefaultValue(((StringProperty)property).getDefault());
                }
                model = modelImpl;
            }
            model.setDescription(property.getDescription());
            swagger.getDefinitions().put(componentName, model);
        }
        return (Model)swagger.getDefinitions().get(componentName);
    }

    private void setHttpMethod(MappingModel mapping, Path pathItem, Operation operation) {
        block9: for (MappingModel.HttpMethod httpMethod : mapping.getHttpMethods()) {
            switch (httpMethod) {
                case GET: {
                    pathItem.get(operation);
                    continue block9;
                }
                case PUT: {
                    pathItem.put(operation);
                    continue block9;
                }
                case POST: {
                    pathItem.post(operation);
                    continue block9;
                }
                case DELETE: {
                    pathItem.delete(operation);
                    continue block9;
                }
                case HEAD: {
                    pathItem.head(operation);
                    continue block9;
                }
                case PATCH: {
                    pathItem.patch(operation);
                    continue block9;
                }
                case OPTIONS: {
                    pathItem.options(operation);
                }
            }
        }
    }

    private List<Parameter> convertQueryString(ParameterModel paramModel, Swagger swagger) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (paramModel.getChildren() != null && paramModel.getChildren().size() > 0) {
            this.convertParameterChildren(paramModel.getChildren(), null, swagger).forEach(o -> parameters.add((Parameter)o));
        } else {
            parameters.add(this.generateSingleParameterSchema("query", paramModel, swagger));
        }
        return parameters;
    }

    private List<Parameter> convertParameterChildren(List<PropertyModel> propertyModels, String paraName, Swagger swagger) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String name = "";
        if (paraName != null) {
            name = paraName + ".";
        }
        for (PropertyModel child : propertyModels) {
            if (child.isArray()) {
                this.convertParameterChildren(child.getChildren(), child.getName(), swagger).forEach(o -> parameters.add((Parameter)o));
                continue;
            }
            if (child.getChildren() == null || child.getChildren().size() == 0) {
                GenericParameter parameter = new GenericParameter();
                parameter.setName(name + child.getName());
                parameter.setDescription(child.getDescription());
                parameter.setExample(child.getExample());
                parameter.setIn("query");
                parameter.setRequired(child.isRequired());
                Property property = this.generateProperty(child.getEnums(), child.isRequired(), child.getExample(), child.getDescription(), child.getPropertyType(), child.getChildren(), swagger);
                parameter.setProperty(property);
                parameter.setDescription(StringUtils.combineStr((String)parameter.getDescription(), (String)property.getDescription()));
                parameters.add((Parameter)parameter);
                continue;
            }
            parameters.addAll(this.convertParameterChildren(child.getChildren(), name + child.getName(), swagger));
        }
        return parameters;
    }

    private Parameter generateSingleParameterSchema(String in, ParameterModel paramModel, Swagger swagger) {
        GenericParameter parameter = new GenericParameter();
        parameter.setIn(in);
        parameter.setName(paramModel.getName());
        parameter.setDescription(paramModel.getDescription());
        parameter.setExample(paramModel.getExample());
        parameter.setRequired(paramModel.isRequired());
        Property property = this.generateProperty(paramModel.getEnums(), paramModel.isRequired(), paramModel.getExample(), paramModel.getDescription(), paramModel.getParameterType(), paramModel.getChildren(), swagger);
        parameter.setProperty(property);
        parameter.setDescription(StringUtils.combineStr((String)parameter.getDescription(), (String)property.getDescription()));
        return parameter;
    }

    private Property generateProperty(List<String> enums, boolean required, String example, String description, Type type, List<PropertyModel> children, Swagger swagger) {
        if (this._config.getTypeInspector().isCollection(type)) {
            return this.generateArrayProperty(enums, required, example, description, type, children, swagger);
        }
        if (enums != null) {
            return this.generateEnumProperty((Class)type, enums, description);
        }
        if (children == null || children.isEmpty()) {
            return this.generateSimpleTypeSchema(required, example, description, type);
        }
        return this.generateComplexSchema(type, children, swagger);
    }

    private Property generateComplexSchema(Type type, List<PropertyModel> children, Swagger swagger) {
        ObjectProperty schema = new ObjectProperty();
        ClassJavadoc classDoc = RuntimeJavadoc.getJavadoc((String)type.getTypeName());
        schema.setDescription(FormatUtils.format((Comment)classDoc.getComment()));
        schema.setProperties(this.generateComplexTypeSchemaProperty(type, children, swagger));
        return schema;
    }

    private Map<String, Property> generateComplexTypeSchemaProperty(Type type, List<PropertyModel> propertyModels, Swagger swagger) {
        LinkedHashMap<String, Property> schemas = new LinkedHashMap<String, Property>();
        for (PropertyModel propertyModel : propertyModels) {
            Property schema = this.generateProperty(propertyModel.getEnums(), propertyModel.isRequired(), propertyModel.getExample(), propertyModel.getDescription(), propertyModel.getPropertyType(), propertyModel.getChildren(), swagger);
            schemas.put(propertyModel.getName(), schema);
        }
        return schemas;
    }

    private Property generateSimpleTypeSchema(boolean required, String example, String description, Type type) {
        ObjectProperty property = new ObjectProperty();
        property.setDescription(description);
        property.setType(this._config.getSwaggerTypeInspector().toSwaggerType(type));
        property.setFormat(this._config.getSwaggerTypeInspector().toSwaggerFormat(type));
        property.setExample(example);
        property.setRequired(required);
        return property;
    }

    private Property generateArrayProperty(List<String> enums, boolean required, String example, String description, Type type, List<PropertyModel> children, Swagger swagger) {
        ArrayProperty arrayProperty = new ArrayProperty();
        arrayProperty.setDescription(description);
        Property property = this.generateProperty(enums, required, example, description, this._config.getTypeInspector().getCollectionComponentType(type), children, swagger);
        arrayProperty.setItems(property);
        arrayProperty.setDescription(StringUtils.combineStr((String)property.getDescription(), (String)arrayProperty.getDescription()));
        return arrayProperty;
    }

    private Property generateEnumProperty(Class clazz, List<String> enums, String description) {
        StringProperty property = new StringProperty();
        property.setDescription(description);
        property.setEnum(enums);
        return property;
    }

    private String getTagName(ControllerModel controller) {
        return this._config.getTypeNameParser().parse((Type)controller.getControllerClass());
    }
}

