/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.swagger2;

import cn.willingxyz.restdoc.core.parse.utils.TextUtils;
import cn.willingxyz.restdoc.swagger2.ISwaggerFilter;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;

public class TagDescriptionAsNameSwaggerFilter
implements ISwaggerFilter {
    @Override
    public Swagger handle(Swagger swagger) {
        if (swagger.getTags() == null) {
            return swagger;
        }
        for (Tag tag : swagger.getTags()) {
            String newTagName = TextUtils.getFirstLine((String)tag.getDescription());
            swagger.getPaths().values().forEach(path -> {
                this.handleOperation(tag, newTagName, path.getGet());
                this.handleOperation(tag, newTagName, path.getPost());
                this.handleOperation(tag, newTagName, path.getPut());
                this.handleOperation(tag, newTagName, path.getDelete());
                this.handleOperation(tag, newTagName, path.getHead());
                this.handleOperation(tag, newTagName, path.getOptions());
                this.handleOperation(tag, newTagName, path.getPatch());
            });
            tag.setName(newTagName);
        }
        return swagger;
    }

    private void handleOperation(Tag tag, String newTagName, Operation operation) {
        if (operation == null) {
            return;
        }
        if (operation.getTags().contains(tag.getName())) {
            operation.getTags().remove(tag.getName());
            operation.getTags().add(newTagName);
        }
    }
}

