package cn.willingxyz.restdoc.springswagger3.examples;

import cn.willingxyz.restdoc.springswagger3.EnableSwagger3;
import cn.willingxyz.restdoc.springswagger3.RestDocConfig;
import cn.willingxyz.restdoc.springswagger3.SwaggerUIConfiguration;
import lombok.var;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

import java.util.Arrays;

@EnableSwagger3
@SpringBootApplication
public class App {

    public static void main(String[] args) {
        SpringApplication.run(App.class);
    }

    @Bean
    RestDocConfig _swaggerConfig()
    {
        return RestDocConfig.builder()
                .apiTitle("rest doc title")
                .apiDescription("rest doc desc")
                .apiVersion("api version")
                .fieldPrefix("_")
                .packages(Arrays.asList("cn.willingxyz.restdoc.springswagger3.examples"))
                .build();
    }
    @Bean
    SwaggerUIConfiguration _swaggerUIConfiguration()
    {
        var uiConfig = new SwaggerUIConfiguration();
//        uiConfig.setDefaultModelRendering("model");
//        uiConfig.setDefaultModelExpandDepth(0);
//        uiConfig.setDocExpansion("full");
        return uiConfig;
    }
}
