/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.springswagger2;

import cn.willingxyz.restdoc.core.config.RestDocConfig;
import cn.willingxyz.restdoc.core.parse.IRestDocGenerator;
import cn.willingxyz.restdoc.core.parse.IRestDocParser;
import cn.willingxyz.restdoc.core.parse.ITypeInspector;
import cn.willingxyz.restdoc.core.parse.ITypeNameParser;
import cn.willingxyz.restdoc.core.parse.RestDocParseConfig;
import cn.willingxyz.restdoc.core.parse.impl.JavaTypeInspector;
import cn.willingxyz.restdoc.core.parse.impl.RestDocParser;
import cn.willingxyz.restdoc.core.parse.impl.TypeNameParser;
import cn.willingxyz.restdoc.spring.SpringControllerResolver;
import cn.willingxyz.restdoc.spring.SpringRestDocParseConfig;
import cn.willingxyz.restdoc.springswagger2.SpringSwagger2Controller;
import cn.willingxyz.restdoc.swagger.common.ISwaggerTypeInspector;
import cn.willingxyz.restdoc.swagger.common.PrimitiveSwaggerTypeInspector;
import cn.willingxyz.restdoc.swagger.common.SwaggerGeneratorConfig;
import cn.willingxyz.restdoc.swagger.common.SwaggerUIConfiguration;
import cn.willingxyz.restdoc.swagger2.Swagger2RestDocGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringSwagger2Configuration {
    @Autowired
    ApplicationContext _applicationContext;

    @Bean(value={"swagger2"})
    IRestDocParser _docParser(@Autowired(required=false) RestDocConfig restDocConfig) {
        if (restDocConfig == null) {
            restDocConfig = RestDocConfig.builder().apiDescription("API descritpion").apiTitle("API title").apiVersion("1.0-SNAPSHOT").packages(Arrays.asList("")).build();
        }
        SpringRestDocParseConfig config = new SpringRestDocParseConfig();
        SwaggerGeneratorConfig docConfig = SwaggerGeneratorConfig.builder().description(restDocConfig.getApiDescription()).title(restDocConfig.getApiTitle()).version(restDocConfig.getApiVersion()).servers(this.convertServers(restDocConfig.getServers())).swaggerTypeInspector((ISwaggerTypeInspector)new PrimitiveSwaggerTypeInspector()).tagDescriptionAsName(restDocConfig.isTagDescriptionAsName()).typeInspector((ITypeInspector)new JavaTypeInspector()).typeNameParser((ITypeNameParser)new TypeNameParser()).hideEmptyController(restDocConfig.isHideEmptyController()).build();
        config.getControllerResolvers().add(new SpringControllerResolver(restDocConfig.getPackages()));
        config.setRestDocGenerator((IRestDocGenerator)new Swagger2RestDocGenerator(docConfig));
        return new RestDocParser((RestDocParseConfig)config);
    }

    private List<SwaggerGeneratorConfig.ServerInfo> convertServers(List<RestDocConfig.Server> servers) {
        ArrayList<SwaggerGeneratorConfig.ServerInfo> serverInfos = new ArrayList<SwaggerGeneratorConfig.ServerInfo>();
        for (RestDocConfig.Server server : servers) {
            SwaggerGeneratorConfig.ServerInfo serverInfo = SwaggerGeneratorConfig.ServerInfo.builder().description(server.getDescription()).url(server.getUrl()).build();
            serverInfos.add(serverInfo);
        }
        return serverInfos;
    }

    @Bean
    SpringSwagger2Controller _springSwagger2Controller(@Qualifier(value="swagger2") IRestDocParser docParser) {
        SwaggerUIConfiguration uiConfiguration;
        try {
            uiConfiguration = (SwaggerUIConfiguration)this._applicationContext.getBean(SwaggerUIConfiguration.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            uiConfiguration = new SwaggerUIConfiguration();
        }
        SpringSwagger2Controller controller = new SpringSwagger2Controller(docParser, uiConfiguration);
        return controller;
    }
}

