/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.spring.examples.ext;

import cn.willingxyz.restdoc.swagger3.IOpenAPIFilter;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;

public class BearerOpenAPIFilter
implements IOpenAPIFilter {
    public OpenAPI handle(OpenAPI openApi) {
        Components components = openApi.getComponents();
        SecurityScheme scheme = new SecurityScheme();
        scheme.setType(SecurityScheme.Type.HTTP);
        scheme.setScheme("bearer");
        scheme.setBearerFormat("JWT");
        components.addSecuritySchemes("bearerAuth", scheme);
        Paths paths = openApi.getPaths();
        SecurityRequirement securityRequirement = new SecurityRequirement().addList("bearerAuth");
        paths.forEach((s, pathItem) -> {
            this.handelPathItem(pathItem.getGet(), securityRequirement);
            this.handelPathItem(pathItem.getPost(), securityRequirement);
            this.handelPathItem(pathItem.getPut(), securityRequirement);
            this.handelPathItem(pathItem.getDelete(), securityRequirement);
            this.handelPathItem(pathItem.getPatch(), securityRequirement);
            this.handelPathItem(pathItem.getHead(), securityRequirement);
            this.handelPathItem(pathItem.getOptions(), securityRequirement);
            this.handelPathItem(pathItem.getTrace(), securityRequirement);
        });
        return openApi;
    }

    private void handelPathItem(Operation operation, SecurityRequirement securityRequirement) {
        if (operation != null) {
            operation.addSecurityItem(securityRequirement);
        }
    }
}

