/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.utils;

import cn.willingxyz.restdoc.core.config.ExtOrder;
import cn.willingxyz.restdoc.core.config.IRestDocParseConfigAware;
import cn.willingxyz.restdoc.core.config.RestDocParseConfig;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class ServiceLoaders {
    public static <T> List<T> loadServices(Class<T> clazz, RestDocParseConfig parseConfig) {
        List processors = new ArrayList();
        ServiceLoader<Object> serviceLoader = ServiceLoader.load(clazz);
        ArrayList finalProcessors = processors;
        serviceLoader.forEach(o -> {
            if (o instanceof IRestDocParseConfigAware) {
                IRestDocParseConfigAware configAware = (IRestDocParseConfigAware)o;
                configAware.setRestDocParseConfig(parseConfig);
            }
            finalProcessors.add(o);
        });
        processors = ServiceLoaders.sortServices(processors);
        return processors;
    }

    private static <T> List<T> sortServices(List<T> processors) {
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        processors.forEach(o -> {
            ExtOrder extOrder = o.getClass().getAnnotation(ExtOrder.class);
            int order = 0;
            if (extOrder != null) {
                order = extOrder.value();
            }
            entries.add(new AbstractMap.SimpleEntry<Integer, Object>(order, o));
        });
        entries.sort(Comparator.comparing(Map.Entry::getKey));
        return entries.stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

