/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.utils;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.util.StringUtils;

public class ReflectUtils {
    public static boolean isEnum(Type type) {
        return type instanceof Class && ((Class)type).isEnum();
    }

    public static void setFieldValue(Object instance, Field field, Object targetValue) {
        if (instance == null || field == null) {
            return;
        }
        try {
            for (PropertyDescriptor descriptor : Introspector.getBeanInfo(instance.getClass()).getPropertyDescriptors()) {
                Method writeMethod = descriptor.getWriteMethod();
                if (!descriptor.getName().equalsIgnoreCase(field.getName()) || writeMethod == null) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(instance, targetValue);
                return;
            }
            field.setAccessible(true);
            field.set(instance, targetValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setFieldValue(Object instance, String fieldName, Object targetValue) {
        if (instance == null) {
            return;
        }
        ReflectUtils.setFieldValue(instance, ReflectUtils.getField(instance.getClass(), fieldName), targetValue);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        if (clazz == null || StringUtils.isEmpty((Object)fieldName)) {
            return null;
        }
        for (Field field : ReflectUtils.getAllFields(clazz)) {
            field.setAccessible(true);
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList classes = new ArrayList();
        do {
            if (clazz == Object.class) continue;
            classes.add(clazz);
        } while ((clazz = clazz.getSuperclass()) != null);
        Collections.reverse(classes);
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class clazz2 : classes) {
            fields.addAll(Arrays.asList(clazz2.getDeclaredFields()));
        }
        return fields;
    }

    public static List<Method> getAllMethods(Class clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        do {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return methods;
    }
}

