/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.postprocessor.impl;

import cn.willingxyz.restdoc.core.annotations.Example;
import cn.willingxyz.restdoc.core.models.ParameterModel;
import cn.willingxyz.restdoc.core.models.PropertyItem;
import cn.willingxyz.restdoc.core.models.PropertyModel;
import cn.willingxyz.restdoc.core.models.ResponseModel;
import cn.willingxyz.restdoc.core.models.TypeContext;
import cn.willingxyz.restdoc.core.parse.postprocessor.IParameterPostProcessor;
import cn.willingxyz.restdoc.core.parse.postprocessor.IPropertyPostProcessor;
import cn.willingxyz.restdoc.core.parse.postprocessor.IResponsePostProcessor;
import cn.willingxyz.restdoc.core.parse.utils.RuntimeJavadocUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class ExamplePostProcessor
implements IPropertyPostProcessor,
IParameterPostProcessor,
IResponsePostProcessor {
    @Override
    public PropertyModel postProcess(PropertyModel propertyModel, TypeContext typeContext) {
        propertyModel.setExample(this.getPropertyExample(propertyModel.getPropertyItem()));
        return propertyModel;
    }

    @Override
    public ParameterModel postProcess(ParameterModel model, Parameter parameter) {
        model.setExample(this.getParameterExample(parameter));
        return model;
    }

    @Override
    public ResponseModel postProcess(ResponseModel model, Method method) {
        model.getReturnModel().setExample(this.getResponseExample(method));
        return model;
    }

    private String getPropertyExample(PropertyItem propertyItem) {
        String example = null;
        if (propertyItem.getField() != null) {
            example = RuntimeJavadocUtils.getTagComment(propertyItem.getField(), "example");
            example = this.getExampleFromAnnotation(propertyItem.getField(), example);
        }
        if ((example == null || example.trim().isEmpty()) && propertyItem.getGetMethod() != null) {
            example = RuntimeJavadocUtils.getTagComment(propertyItem.getGetMethod(), "returnExample");
            example = this.getExampleFromAnnotation(propertyItem.getGetMethod(), example);
        }
        if ((example == null || example.trim().isEmpty()) && propertyItem.getSetMethod() != null) {
            example = RuntimeJavadocUtils.getTagComment(propertyItem.getSetMethod(), "paramExample");
            example = this.getExampleFromAnnotation(propertyItem.getSetMethod(), example);
        }
        return example;
    }

    private String getParameterExample(Parameter parameter) {
        String example = RuntimeJavadocUtils.getTagComment((Method)parameter.getDeclaringExecutable(), "paramExample", parameter.getName());
        return this.getExampleFromAnnotation(parameter, example);
    }

    private String getResponseExample(Method method) {
        String example = RuntimeJavadocUtils.getTagComment(method, "returnExample");
        return this.getExampleFromAnnotation(method, example);
    }

    private String getExampleFromAnnotation(AnnotatedElement element, String example) {
        Example exampleAnno;
        if ((example == null || example.trim().isEmpty()) && (exampleAnno = element.getAnnotation(Example.class)) != null) {
            example = exampleAnno.value();
        }
        return example;
    }
}

