/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.impl;

import cn.willingxyz.restdoc.core.config.RestDocParseConfig;
import cn.willingxyz.restdoc.core.models.ControllerModel;
import cn.willingxyz.restdoc.core.models.ParameterModel;
import cn.willingxyz.restdoc.core.models.PathModel;
import cn.willingxyz.restdoc.core.models.ResponseModel;
import cn.willingxyz.restdoc.core.models.RootModel;
import cn.willingxyz.restdoc.core.parse.IControllerFilter;
import cn.willingxyz.restdoc.core.parse.IControllerParser;
import cn.willingxyz.restdoc.core.parse.IControllerResolver;
import cn.willingxyz.restdoc.core.parse.IMethodFilter;
import cn.willingxyz.restdoc.core.parse.IMethodParameterFilter;
import cn.willingxyz.restdoc.core.parse.IMethodParameterParser;
import cn.willingxyz.restdoc.core.parse.IMethodParser;
import cn.willingxyz.restdoc.core.parse.IMethodReturnParser;
import cn.willingxyz.restdoc.core.parse.IRestDocParser;
import cn.willingxyz.restdoc.core.parse.utils.ParamUtils;
import cn.willingxyz.restdoc.core.parse.utils.ReflectUtils;
import cn.willingxyz.restdoc.core.parse.utils.RuntimeJavadocUtils;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;

public class RestDocParser
implements IRestDocParser {
    private final RestDocParseConfig _configuration;
    private static final LocalVariableTableParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();

    public RestDocParser(RestDocParseConfig configuration) {
        this._configuration = configuration;
    }

    @Override
    public String parse() {
        RootModel rootModel = new RootModel();
        for (IControllerResolver controllerResolver : this._configuration.getControllerResolvers()) {
            for (Class clazz : controllerResolver.getClasses()) {
                if (!this.filterController(clazz)) continue;
                ControllerModel controllerModel = this.handleController(clazz);
                rootModel.getControllers().add(controllerModel);
            }
        }
        return this._configuration.getRestDocGenerator().generate(rootModel);
    }

    private boolean filterController(Class clazz) {
        for (IControllerFilter controllerFilter : this._configuration.getControllerFilters()) {
            if (controllerFilter.isSupport(clazz)) continue;
            return false;
        }
        return true;
    }

    private ControllerModel handleController(Class clazz) {
        ControllerModel controllerModel = new ControllerModel();
        ClassJavadoc classDoc = RuntimeJavadocUtils.getClassJavadoc(clazz);
        for (IControllerParser classParser : this._configuration.getControllerParsers()) {
            classParser.parse(clazz, classDoc, controllerModel);
        }
        for (Method method : ReflectUtils.getAllMethods(clazz)) {
            Optional<MethodJavadoc> methodDoc;
            PathModel pathModel = this.handleMethod(method, (methodDoc = RuntimeJavadocUtils.getAllMethodJavadoc(clazz).stream().filter(o -> o.getName().equals(method.getName())).findFirst()).orElse(null));
            if (pathModel == null) continue;
            controllerModel.getControllerMethods().add(pathModel);
        }
        return controllerModel;
    }

    private PathModel handleMethod(Method method, MethodJavadoc methodJavadoc) {
        for (IMethodFilter iMethodFilter : this._configuration.getMethodFilters()) {
            if (iMethodFilter.isSupport(method)) continue;
            return null;
        }
        PathModel pathModel = new PathModel();
        for (IMethodParser methodParser : this._configuration.getMethodParsers()) {
            pathModel = methodParser.parse(method, methodJavadoc, pathModel);
        }
        String[] stringArray = parameterNameDiscoverer.getParameterNames(method);
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            ParameterModel parameterModel;
            String parameterName;
            ParamJavadoc paramJavadoc = null;
            Parameter parameter = parameters[i];
            if (!parameter.isNamePresent() && stringArray != null) {
                parameterName = stringArray[i];
                ParamUtils.cacheParameterName(parameter, parameterName);
            } else {
                parameterName = parameter.getName();
            }
            if (methodJavadoc != null) {
                paramJavadoc = methodJavadoc.getParams().stream().filter(o -> o.getName().equals(parameterName)).findFirst().orElse(null);
            }
            if ((parameterModel = this.handleMethodParameter(parameter, paramJavadoc)) == null) continue;
            pathModel.getParameters().add(parameterModel);
        }
        Comment returnComment = null;
        if (methodJavadoc != null) {
            returnComment = methodJavadoc.getReturns();
        }
        List<ResponseModel> responseModels = this.handleReturnValue(method, returnComment);
        pathModel.setResponse(responseModels);
        return pathModel;
    }

    private List<ResponseModel> handleReturnValue(Method method, Comment returns) {
        ArrayList<ResponseModel> responseModels = new ArrayList<ResponseModel>();
        ResponseModel lastResponseModel = null;
        for (IMethodReturnParser returnParser : this._configuration.getReturnParsers()) {
            if (returnParser.isNew()) {
                ResponseModel responseModel;
                lastResponseModel = responseModel = returnParser.parse(method, returns, new ResponseModel());
                responseModels.add(responseModel);
                continue;
            }
            if (lastResponseModel == null) {
                lastResponseModel = new ResponseModel();
                responseModels.add(lastResponseModel);
            }
            lastResponseModel = returnParser.parse(method, returns, lastResponseModel);
        }
        for (int i = 0; i < responseModels.size(); ++i) {
            ResponseModel responseModel = (ResponseModel)responseModels.get(i);
            responseModel = this._configuration.getResponsePostProcessor().postProcess(responseModel, method);
            responseModels.set(i, responseModel);
        }
        responseModels = responseModels.stream().filter(o -> o != null).collect(Collectors.toList());
        return responseModels;
    }

    private ParameterModel handleMethodParameter(Parameter parameter, ParamJavadoc paramJavadoc) {
        for (IMethodParameterFilter methodParameterResolver : this._configuration.getMethodParameterFilters()) {
            if (methodParameterResolver.isSupport(parameter)) continue;
            return null;
        }
        ParameterModel parameterModel = new ParameterModel();
        for (IMethodParameterParser parameterParser : this._configuration.getMethodParameterParsers()) {
            if (!parameterParser.isSupport(parameter)) continue;
            parameterModel = parameterParser.parse(parameter, paramJavadoc, parameterModel);
            parameterModel = this._configuration.getParameterPostProcessor().postProcess(parameterModel, parameter);
            break;
        }
        return parameterModel;
    }
}

