/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.impl;

import cn.willingxyz.restdoc.core.config.RestDocParseConfig;
import cn.willingxyz.restdoc.core.models.PropertyItem;
import cn.willingxyz.restdoc.core.parse.IPropertyResolver;
import cn.willingxyz.restdoc.core.parse.utils.MyParameterizedType;
import cn.willingxyz.restdoc.core.parse.utils.ReflectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyResolver
implements IPropertyResolver {
    private final RestDocParseConfig _config;
    private static Set<Class> _ignoreClasses = new HashSet<Class>(){
        {
            this.add(Class.class);
            this.add(ParameterizedType.class);
            this.add(ClassLoader.class);
            this.add(Enum.class);
            this.add(Map.class);
        }
    };

    public PropertyResolver(RestDocParseConfig config) {
        this._config = config;
    }

    @Override
    public List<PropertyItem> resolve(Type type) {
        if (this.shouldIgnoreType(this._config, type)) {
            return new ArrayList<PropertyItem>();
        }
        if (type instanceof Class) {
            return this.getPropertyItems(this._config, (Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable[] typeParameters = rawType.getTypeParameters();
            List<PropertyItem> propertyItems = this.getPropertyItems(this._config, rawType);
            for (PropertyItem propertyItem : propertyItems) {
                Type propType = propertyItem.getPropertyType();
                if (propType instanceof TypeVariable) {
                    propType = this.getTypeVariable(typeArguments, typeParameters, propType);
                } else if (propType instanceof ParameterizedType) {
                    ParameterizedType propParameterizedType = (ParameterizedType)propType;
                    ArrayList<Type> convertedActualArgs = new ArrayList<Type>();
                    for (Type actualArg : propParameterizedType.getActualTypeArguments()) {
                        if (actualArg instanceof TypeVariable) {
                            convertedActualArgs.add(this.getTypeVariable(typeArguments, typeParameters, actualArg));
                            continue;
                        }
                        convertedActualArgs.add(actualArg);
                    }
                    propType = new MyParameterizedType(propParameterizedType.getRawType(), convertedActualArgs.toArray(new Type[0]), propParameterizedType.getOwnerType());
                }
                propertyItem.setPropertyType(propType);
            }
            return propertyItems;
        }
        return new ArrayList<PropertyItem>();
    }

    private Type getTypeVariable(Type[] typeArguments, TypeVariable[] typeParameters, Type propType) {
        for (int x = 0; x < typeParameters.length; ++x) {
            if (!typeParameters[x].getTypeName().equals(propType.getTypeName())) continue;
            propType = typeArguments[x];
        }
        return propType;
    }

    public List<PropertyItem> getPropertyItems(RestDocParseConfig configuration, Class clazz) {
        List<Field> fields = ReflectUtils.getAllFields(clazz);
        List<PropertyItem> items = new ArrayList<PropertyItem>();
        for (Method method : clazz.getMethods()) {
            if (method.getName().equals("getClass") || !this.isPropertyMethod(method)) continue;
            String propName = this.getPropertyNameByMethod(method);
            PropertyItem propertyItem = items.stream().filter(o -> o.getPropertyName().equals(propName)).findFirst().orElse(null);
            if (propertyItem == null) {
                propertyItem = new PropertyItem();
                items.add(propertyItem);
            }
            propertyItem.setPropertyName(propName);
            Field field = this.getFieldByPropertyName(configuration, fields, propName, configuration.getFieldPrefix());
            if (field != null) {
                propertyItem.setField(field);
            }
            if (method.getName().startsWith("get") || method.getName().startsWith("is")) {
                propertyItem.setGetMethod(method);
            } else {
                propertyItem.setSetMethod(method);
            }
            propertyItem.setPropertyType(this.getPropertyType(propertyItem));
        }
        items = this.sortByField(items, fields);
        return items;
    }

    public Type getPropertyType(PropertyItem item) {
        Type propType = null;
        if (item.getField() != null) {
            propType = item.getField().getGenericType();
        } else if (item.getGetMethod() != null) {
            propType = item.getGetMethod().getGenericReturnType();
        } else if (item.getSetMethod() != null) {
            propType = item.getSetMethod().getGenericParameterTypes()[0];
        }
        return propType;
    }

    private List<PropertyItem> sortByField(List<PropertyItem> items, List<Field> fields) {
        ArrayList<PropertyItem> sortedItems = new ArrayList<PropertyItem>();
        for (Field field : fields) {
            PropertyItem item = items.stream().filter(o -> o.getField() != null && o.getField() == field).findFirst().orElse(null);
            if (item == null) continue;
            sortedItems.add(item);
        }
        for (PropertyItem item : items) {
            if (sortedItems.contains(item)) continue;
            sortedItems.add(item);
        }
        return sortedItems;
    }

    private Field getFieldByPropertyName(RestDocParseConfig configuration, List<Field> fields, String propName, String prefix) {
        String name;
        String fieldName;
        for (Field field : fields) {
            fieldName = this.getFieldNameByFiled(configuration, field);
            if (prefix != null && fieldName.startsWith(prefix)) {
                name = fieldName.substring(prefix.length());
                if (name.equals(propName)) {
                    return field;
                }
                if ((name = Character.toLowerCase(name.charAt(0)) + name.substring(1)).equals(propName)) {
                    return field;
                }
            }
            if (!fieldName.equals(propName)) continue;
            return field;
        }
        for (Field field : fields) {
            fieldName = this.getFieldNameByFiled(configuration, field);
            if (field.getType() != Boolean.TYPE || !fieldName.startsWith("is") || fieldName.length() <= 2) continue;
            name = fieldName.substring(2);
            if (!(name = Character.toLowerCase(name.charAt(0)) + name.substring(1)).equals(propName)) continue;
            return field;
        }
        return null;
    }

    private boolean isPropertyMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && (method.getName().startsWith("get") && method.getName().length() > 3 && method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE && method.getReturnType() != Void.class || method.getName().startsWith("set") && method.getName().length() > 3 && method.getParameterCount() == 1 && (method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class) || method.getName().startsWith("is") && method.getReturnType() == Boolean.TYPE && method.getParameterCount() == 0 && method.getName().length() > 2);
    }

    private String getPropertyNameByMethod(Method method) {
        String propertyName = null;
        if (method.getName().startsWith("is")) {
            propertyName = method.getName().substring(2);
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
        } else {
            propertyName = method.getName().substring(3);
            if (!(propertyName.length() >= 2 && Character.isUpperCase(propertyName.charAt(1)) || propertyName.length() >= 2 && Character.isUpperCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1)))) {
                propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            }
        }
        return propertyName;
    }

    private String getFieldNameByFiled(RestDocParseConfig configuration, Field item) {
        return item.getName();
    }

    private boolean shouldIgnoreType(RestDocParseConfig config, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            type = parameterizedType.getRawType();
        }
        for (Class clazz : _ignoreClasses) {
            if (!(type instanceof Class) || !clazz.isAssignableFrom((Class)type)) continue;
            return true;
        }
        return config.getTypeInspector().isSimpleType(type);
    }
}

