/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.impl;

import cn.willingxyz.restdoc.core.config.RestDocParseConfig;
import cn.willingxyz.restdoc.core.models.PropertyItem;
import cn.willingxyz.restdoc.core.models.PropertyModel;
import cn.willingxyz.restdoc.core.parse.IPropertyParser;
import cn.willingxyz.restdoc.core.parse.IPropertyResolver;
import cn.willingxyz.restdoc.core.parse.utils.FormatUtils;
import cn.willingxyz.restdoc.core.parse.utils.GraphChecker;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PropertyParser
implements IPropertyParser {
    private final RestDocParseConfig _config;
    private final IPropertyResolver _propertyResolver;

    public PropertyParser(RestDocParseConfig config, IPropertyResolver propertyResolver) {
        this._config = config;
        this._propertyResolver = propertyResolver;
    }

    @Override
    public PropertyModel parse(PropertyItem item) {
        GraphChecker<Type> graphChecker = new GraphChecker<Type>();
        return this.parseProperty(this._config, null, graphChecker, item);
    }

    private PropertyModel parseProperty(RestDocParseConfig configuration, Type fromType, GraphChecker<Type> map, PropertyItem propertyItem) {
        PropertyModel propertyModel = new PropertyModel();
        propertyModel.setName(propertyItem.getPropertyName());
        propertyModel.setPropertyType(propertyItem.getPropertyType());
        propertyModel.setPropertyItem(propertyItem);
        this.setPropertyDescription(propertyItem, propertyItem, propertyModel);
        if (configuration.getTypeInspector().isCollection(propertyItem.getPropertyType())) {
            propertyModel.setArray(true);
            propertyModel.setChildren(this.parseTypeProperty(configuration, fromType, configuration.getTypeInspector().getCollectionComponentType(propertyItem.getPropertyType()), map));
        } else {
            propertyModel.setChildren(this.parseTypeProperty(configuration, fromType, propertyItem.getPropertyType(), map));
        }
        propertyModel.getChildren().forEach(o -> o.setParentPropertyItem(propertyModel.getPropertyItem()));
        return propertyModel;
    }

    private void setPropertyDescription(PropertyItem item, PropertyItem propertyItem, PropertyModel propertyModel) {
        Class declaringClass = item.getDeclaringClass();
        ClassJavadoc classdoc = RuntimeJavadoc.getJavadoc((Class)declaringClass);
        if (propertyItem.getField() != null) {
            Optional<FieldJavadoc> fieldDoc = classdoc.getFields().stream().filter(o -> o.getName().equals(propertyItem.getField().getName())).findFirst();
            fieldDoc.ifPresent(fieldJavadoc -> propertyModel.setDescription(FormatUtils.format(fieldJavadoc.getComment())));
        }
        if ((propertyModel.getDescription() == null || propertyModel.getDescription().length() == 0) && item.getGetMethod() != null) {
            Optional<MethodJavadoc> getMethodDoc = classdoc.getMethods().stream().filter(o -> o.getName().equals(item.getGetMethod().getName())).findFirst();
            getMethodDoc.ifPresent(methodJavadoc -> propertyModel.setDescription(FormatUtils.format(methodJavadoc.getComment())));
        }
        if ((propertyModel.getDescription() == null || propertyModel.getDescription().length() == 0) && item.getSetMethod() != null) {
            Optional<MethodJavadoc> setMethodDoc = classdoc.getMethods().stream().filter(o -> o.getName().equals(item.getSetMethod().getName())).findFirst();
            setMethodDoc.ifPresent(methodJavadoc -> propertyModel.setDescription(FormatUtils.format(methodJavadoc.getComment())));
        }
    }

    private List<PropertyModel> parseTypeProperty(RestDocParseConfig configuration, Type fromType, Type toType, GraphChecker<Type> graph) {
        ArrayList<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
        if (graph.add(fromType, toType)) {
            return propertyModels;
        }
        if (configuration.getTypeInspector().isCollection(toType)) {
            System.out.println("type:" + toType);
            assert (false);
        } else {
            if (toType instanceof Map) {
                return this.parseClassProperty(configuration, Object.class, graph);
            }
            if (toType instanceof ParameterizedType) {
                if (Map.class.isAssignableFrom((Class)((ParameterizedType)toType).getRawType())) {
                    return this.parseClassProperty(configuration, Object.class, graph);
                }
                return this.parseParameterizedTypeProperty(configuration, (ParameterizedType)toType, graph);
            }
            if (toType instanceof Class) {
                return this.parseClassProperty(configuration, (Class)toType, graph);
            }
        }
        return propertyModels;
    }

    private List<PropertyModel> parseParameterizedTypeProperty(RestDocParseConfig configuration, ParameterizedType parameterizedType, GraphChecker<Type> map) {
        ArrayList<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
        for (PropertyItem propertyItem : this._propertyResolver.resolve(parameterizedType)) {
            PropertyModel propertyModel = this.parseProperty(configuration, parameterizedType, map, propertyItem);
            propertyModels.add(propertyModel);
        }
        return propertyModels;
    }

    private List<PropertyModel> parseClassProperty(RestDocParseConfig configuration, Class<?> clazz, GraphChecker<Type> map) {
        ArrayList<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
        for (PropertyItem item : this._propertyResolver.resolve(clazz)) {
            propertyModels.add(this.parseProperty(configuration, clazz, map, item));
        }
        return propertyModels;
    }
}

