/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.impl;

import cn.willingxyz.restdoc.core.config.AbstractRestDocParseConfigAware;
import cn.willingxyz.restdoc.core.models.ResponseModel;
import cn.willingxyz.restdoc.core.models.ReturnModel;
import cn.willingxyz.restdoc.core.models.TypeContext;
import cn.willingxyz.restdoc.core.parse.IMethodReturnParser;
import cn.willingxyz.restdoc.core.parse.utils.FormatUtils;
import com.github.therapi.runtimejavadoc.Comment;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public abstract class AbstractMethodReturnParser
extends AbstractRestDocParseConfigAware
implements IMethodReturnParser {
    @Override
    public ResponseModel parse(Method method, Comment returns, ResponseModel responseModel) {
        responseModel.setStatusCode(this.parseStatusCode(method));
        ReturnModel returnModel = responseModel.getReturnModel();
        returnModel.setDescription(FormatUtils.format(returns));
        Type actualType = method.getGenericReturnType();
        if (actualType == Optional.class) {
            if (method.getGenericReturnType() instanceof ParameterizedType) {
                actualType = ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0];
            } else {
                throw new RuntimeException("why?");
            }
        }
        returnModel.setReturnType(actualType);
        boolean isArray = this._config.getTypeInspector().isCollection(actualType);
        returnModel.setArray(isArray);
        if (!isArray) {
            returnModel.setChildren(this._config.getTypeParser().parse(new TypeContext(actualType, null, method)));
        } else {
            returnModel.setChildren(this._config.getTypeParser().parse(new TypeContext(this._config.getTypeInspector().getCollectionComponentType(actualType), null, method)));
        }
        this.parseInternal(method, actualType, responseModel);
        return responseModel;
    }

    protected ResponseModel parseInternal(Method method, Type actualType, ResponseModel responseModel) {
        return responseModel;
    }

    protected abstract int parseStatusCode(Method var1);

    @Override
    public boolean isNew() {
        return false;
    }
}

