/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.utils;

import cn.willingxyz.restdoc.core.models.PropertyModel;
import cn.willingxyz.restdoc.core.parse.RestDocParseConfig;
import cn.willingxyz.restdoc.core.parse.utils.FormatUtils;
import cn.willingxyz.restdoc.core.parse.utils.GraphChecker;
import cn.willingxyz.restdoc.core.parse.utils.MyParameterizedType;
import cn.willingxyz.restdoc.core.parse.utils.ReflectUtils;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TypeParseUtils {
    private static Set<Class> _ignoreClasses = new HashSet<Class>(){
        {
            this.add(Class.class);
            this.add(ParameterizedType.class);
            this.add(ClassLoader.class);
            this.add(Enum.class);
        }
    };

    public static List<PropertyModel> parseTypeProperty(RestDocParseConfig configuration, Type type) {
        return TypeParseUtils.parseTypeProperty(configuration, null, type, new GraphChecker<Type>());
    }

    private static List<PropertyModel> parseTypeProperty(RestDocParseConfig configuration, Type fromType, Type toType, GraphChecker<Type> graph) {
        ArrayList<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
        if (TypeParseUtils.shouldIgnoreType(configuration, toType)) {
            return propertyModels;
        }
        if (graph.add(fromType, toType)) {
            return propertyModels;
        }
        if (configuration.getTypeInspector().isCollection(toType)) {
            PropertyModel propertyModel = new PropertyModel();
            propertyModel.setName("array");
            propertyModel.setArray(true);
            propertyModel.setPropertyType(toType);
            List<PropertyModel> children = TypeParseUtils.parseTypeProperty(configuration, toType, configuration.getTypeInspector().getCollectionComponentType(toType), graph);
            propertyModel.setChildren(children);
            propertyModels.add(propertyModel);
        } else {
            if (toType instanceof Map) {
                return TypeParseUtils.parseClassProperty(configuration, Object.class, graph);
            }
            if (toType instanceof ParameterizedType) {
                if (Map.class.isAssignableFrom((Class)((ParameterizedType)toType).getRawType())) {
                    return TypeParseUtils.parseClassProperty(configuration, Object.class, graph);
                }
                TypeParseUtils.parseParameterizedTypeProperty(configuration, (ParameterizedType)toType, propertyModels, graph);
            } else if (toType instanceof Class) {
                return TypeParseUtils.parseClassProperty(configuration, (Class)toType, graph);
            }
        }
        return propertyModels;
    }

    private static void parseParameterizedTypeProperty(RestDocParseConfig configuration, ParameterizedType parameterizedType, ArrayList<PropertyModel> propertyModels, GraphChecker<Type> map) {
        Class rawType = (Class)parameterizedType.getRawType();
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        TypeVariable[] typeParameters = rawType.getTypeParameters();
        for (ReflectUtils.PropertyItem propertyItem : ReflectUtils.getPropertyItems(configuration, rawType)) {
            Type propType = propertyItem.getPropertyType();
            if (propType instanceof TypeVariable) {
                propType = TypeParseUtils.getTypeVariable(typeArguments, typeParameters, propType);
            } else if (propType instanceof ParameterizedType) {
                ParameterizedType propParameterizedType = (ParameterizedType)propType;
                ArrayList<Type> convertedActualArgs = new ArrayList<Type>();
                for (Type actualArg : propParameterizedType.getActualTypeArguments()) {
                    if (actualArg instanceof TypeVariable) {
                        convertedActualArgs.add(TypeParseUtils.getTypeVariable(typeArguments, typeParameters, actualArg));
                        continue;
                    }
                    convertedActualArgs.add(actualArg);
                }
                propType = new MyParameterizedType(propParameterizedType.getRawType(), convertedActualArgs.toArray(new Type[0]), propParameterizedType.getOwnerType());
            }
            TypeParseUtils.parseProperty(configuration, parameterizedType, propertyModels, map, propertyItem, propType);
        }
    }

    private static Type getTypeVariable(Type[] typeArguments, TypeVariable[] typeParameters, Type propType) {
        for (int x = 0; x < typeParameters.length; ++x) {
            if (!typeParameters[x].getTypeName().equals(propType.getTypeName())) continue;
            propType = typeArguments[x];
        }
        return propType;
    }

    private static void parseProperty(RestDocParseConfig configuration, Type fromType, ArrayList<PropertyModel> propertyModels, GraphChecker<Type> map, ReflectUtils.PropertyItem propertyItem, Type propType) {
        PropertyModel propertyModel = new PropertyModel();
        propertyModel.setName(propertyItem.getPropertyName());
        propertyModel.setPropertyType(propType);
        TypeParseUtils.setPropertyDescription(propertyItem, propertyItem, propertyModel);
        if (configuration.getTypeInspector().isCollection(propType)) {
            propertyModel.setArray(true);
            propertyModel.setChildren(TypeParseUtils.parseTypeProperty(configuration, fromType, configuration.getTypeInspector().getCollectionComponentType(propType), map));
        } else {
            propertyModel.setChildren(TypeParseUtils.parseTypeProperty(configuration, fromType, propType, map));
        }
        propertyModels.add(propertyModel);
    }

    private static boolean shouldIgnoreType(RestDocParseConfig config, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            type = parameterizedType.getRawType();
        }
        for (Class clazz : _ignoreClasses) {
            if (!(type instanceof Class) || !clazz.isAssignableFrom((Class)type)) continue;
            return true;
        }
        return config.getTypeInspector().isSimpleType(type);
    }

    private static List<PropertyModel> parseClassProperty(RestDocParseConfig configuration, Class<?> clazz, GraphChecker<Type> map) {
        ArrayList<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
        for (ReflectUtils.PropertyItem item : ReflectUtils.getPropertyItems(configuration, clazz)) {
            Type propType = item.getPropertyType();
            TypeParseUtils.parseProperty(configuration, clazz, propertyModels, map, item, propType);
        }
        return propertyModels;
    }

    private static void setPropertyDescription(ReflectUtils.PropertyItem item, ReflectUtils.PropertyItem propertyItem, PropertyModel propertyModel) {
        Optional<MethodJavadoc> setMethodDoc;
        Optional<MethodJavadoc> getMethodDoc;
        Optional<FieldJavadoc> fieldDoc;
        Class declaringClass = item.getDeclaringClass();
        ClassJavadoc classdoc = RuntimeJavadoc.getJavadoc((Class)declaringClass);
        if (propertyItem.getField() != null && (fieldDoc = classdoc.getFields().stream().filter(o -> o.getName().equals(propertyItem.getField().getName())).findFirst()).isPresent()) {
            propertyModel.setDescription(FormatUtils.format(fieldDoc.get().getComment()));
        }
        if ((propertyModel.getDescription() == null || propertyModel.getDescription().length() == 0) && item.getGetMethod() != null && (getMethodDoc = classdoc.getMethods().stream().filter(o -> o.getName().equals(item.getGetMethod().getName())).findFirst()).isPresent()) {
            propertyModel.setDescription(FormatUtils.format(getMethodDoc.get().getComment()));
        }
        if ((propertyModel.getDescription() == null || propertyModel.getDescription().length() == 0) && item.getSetMethod() != null && (setMethodDoc = classdoc.getMethods().stream().filter(o -> o.getName().equals(item.getSetMethod().getName())).findFirst()).isPresent()) {
            propertyModel.setDescription(FormatUtils.format(setMethodDoc.get().getComment()));
        }
    }
}

