/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.utils;

import cn.willingxyz.restdoc.core.parse.RestDocParseConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectUtils {
    public static boolean isEnum(Type type) {
        return type instanceof Class && ((Class)type).isEnum();
    }

    private static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return fields;
    }

    private static Map<String, Field> getFieldMap(RestDocParseConfig configuration, Class clazz) {
        List<Field> list = ReflectUtils.getAllFields(clazz);
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field item : list) {
            String name = ReflectUtils.getFileNameByFiled(configuration, item);
            map.put(name, item);
        }
        return map;
    }

    private static String getFileNameByFiled(RestDocParseConfig configuration, Field item) {
        return item.getName();
    }

    public static PropertyItem[] getPropertyItems(RestDocParseConfig configuration, Class clazz) {
        Map<String, Field> fields = ReflectUtils.getFieldMap(configuration, clazz);
        HashMap<String, PropertyItem> items = new HashMap<String, PropertyItem>();
        for (Method method : clazz.getMethods()) {
            if (method.getName().equals("getClass") || !ReflectUtils.isPropertyMethod(method)) continue;
            String propName = ReflectUtils.getPropertyNameByMethod(method);
            PropertyItem propertyItem = (PropertyItem)items.get(propName);
            if (propertyItem == null) {
                propertyItem = new PropertyItem();
                items.put(propName, propertyItem);
            }
            propertyItem.setPropertyName(propName);
            Field field = ReflectUtils.getFieldByPropertyName(fields, propName, configuration.getFieldPrefix());
            if (field != null) {
                propertyItem.setField(field);
            }
            if (method.getName().startsWith("get") || method.getName().startsWith("is")) {
                propertyItem.setGetMethod(method);
                continue;
            }
            propertyItem.setSetMethod(method);
        }
        return items.values().toArray(new PropertyItem[0]);
    }

    private static Field getFieldByPropertyName(Map<String, Field> fields, String propName, String prefix) {
        String name;
        for (String fieldName : fields.keySet()) {
            if (prefix != null && fieldName.startsWith(prefix)) {
                name = fieldName.substring(prefix.length());
                if (name.equals(propName)) {
                    return fields.get(fieldName);
                }
                if (!(name = Character.toLowerCase(name.charAt(0)) + name.substring(1)).equals(propName) || name.equals(propName)) {
                    // empty if block
                }
            }
            if (!fieldName.equals(propName)) continue;
            return fields.get(fieldName);
        }
        for (String fieldName : fields.keySet()) {
            if (fields.get(fieldName).getType() != Boolean.TYPE || !fieldName.startsWith("is") || fieldName.length() <= 2) continue;
            name = fieldName.substring(2);
            if (!(name = Character.toLowerCase(name.charAt(0)) + name.substring(1)).equals(propName)) continue;
            return fields.get(fieldName);
        }
        return null;
    }

    public static List<Method> getAllMethods(Class clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        do {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return methods;
    }

    private static boolean isPropertyMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && (method.getName().startsWith("get") && method.getName().length() > 3 && method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE && method.getReturnType() != Void.class || method.getName().startsWith("set") && method.getName().length() > 3 && method.getParameterCount() == 1 && (method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class) || method.getName().startsWith("is") && method.getReturnType() == Boolean.TYPE && method.getParameterCount() == 0 && method.getName().length() > 2);
    }

    private static String getPropertyNameByMethod(Method method) {
        String propertyName = null;
        if (method.getName().startsWith("is")) {
            propertyName = method.getName().substring(2);
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
        } else {
            propertyName = method.getName().substring(3);
            if (!(propertyName.length() >= 2 && Character.isUpperCase(propertyName.charAt(1)) || propertyName.length() >= 2 && Character.isUpperCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1)))) {
                propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            }
        }
        return propertyName;
    }

    public static class PropertyItem {
        private String _propertyName;
        private Field _field;
        private Method _getMethod;
        private Method _setMethod;

        public Type getPropertyType() {
            Type propType = null;
            if (this.getField() != null) {
                propType = this.getField().getGenericType();
            } else if (this.getGetMethod() != null) {
                propType = this.getGetMethod().getGenericReturnType();
            } else if (this.getSetMethod() != null) {
                propType = this.getSetMethod().getGenericParameterTypes()[0];
            }
            return propType;
        }

        public Class getDeclaringClass() {
            Class<?> declaringClass = null;
            if (this.getField() != null) {
                declaringClass = this.getField().getDeclaringClass();
            } else if (this.getGetMethod() != null) {
                declaringClass = this.getGetMethod().getDeclaringClass();
            } else if (this.getSetMethod() != null) {
                declaringClass = this.getSetMethod().getDeclaringClass();
            }
            return declaringClass;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public Field getField() {
            return this._field;
        }

        public Method getGetMethod() {
            return this._getMethod;
        }

        public Method getSetMethod() {
            return this._setMethod;
        }

        public void setPropertyName(String _propertyName) {
            this._propertyName = _propertyName;
        }

        public void setField(Field _field) {
            this._field = _field;
        }

        public void setGetMethod(Method _getMethod) {
            this._getMethod = _getMethod;
        }

        public void setSetMethod(Method _setMethod) {
            this._setMethod = _setMethod;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyItem)) {
                return false;
            }
            PropertyItem other = (PropertyItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$_propertyName = this.getPropertyName();
            String other$_propertyName = other.getPropertyName();
            if (this$_propertyName == null ? other$_propertyName != null : !this$_propertyName.equals(other$_propertyName)) {
                return false;
            }
            Field this$_field = this.getField();
            Field other$_field = other.getField();
            if (this$_field == null ? other$_field != null : !((Object)this$_field).equals(other$_field)) {
                return false;
            }
            Method this$_getMethod = this.getGetMethod();
            Method other$_getMethod = other.getGetMethod();
            if (this$_getMethod == null ? other$_getMethod != null : !((Object)this$_getMethod).equals(other$_getMethod)) {
                return false;
            }
            Method this$_setMethod = this.getSetMethod();
            Method other$_setMethod = other.getSetMethod();
            return !(this$_setMethod == null ? other$_setMethod != null : !((Object)this$_setMethod).equals(other$_setMethod));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertyItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $_propertyName = this.getPropertyName();
            result = result * 59 + ($_propertyName == null ? 43 : $_propertyName.hashCode());
            Field $_field = this.getField();
            result = result * 59 + ($_field == null ? 43 : ((Object)$_field).hashCode());
            Method $_getMethod = this.getGetMethod();
            result = result * 59 + ($_getMethod == null ? 43 : ((Object)$_getMethod).hashCode());
            Method $_setMethod = this.getSetMethod();
            result = result * 59 + ($_setMethod == null ? 43 : ((Object)$_setMethod).hashCode());
            return result;
        }

        public String toString() {
            return "ReflectUtils.PropertyItem(_propertyName=" + this.getPropertyName() + ", _field=" + this.getField() + ", _getMethod=" + this.getGetMethod() + ", _setMethod=" + this.getSetMethod() + ")";
        }
    }
}

