/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.utils;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;

public class GraphChecker<T> {
    private Node<T> _root;

    public boolean add(T from, T to) {
        if (from == null) {
            this._root = new Node();
            this._root.setData(to);
            return false;
        }
        Node<T> fromNode = this.getNode(this._root, from);
        Node<T> toNode = this.getNode(this._root, to);
        if (toNode == null) {
            toNode = new Node();
            toNode.setData(to);
        }
        fromNode.getNodes().add(toNode);
        if (this.isCycle(this._root)) {
            fromNode.getNodes().remove(toNode);
            return true;
        }
        return false;
    }

    private boolean isCycle(Node<T> node) {
        Stack<Node<T>> stack = new Stack<Node<T>>();
        return this.handle(node, stack);
    }

    private boolean handle(Node<T> node, Stack<Node<T>> stack) {
        stack.push(node);
        if (this.stackHasSameNode(stack)) {
            return true;
        }
        for (Node<T> child : node.getNodes()) {
            if (!this.handle(child, stack)) continue;
            return true;
        }
        stack.pop();
        return false;
    }

    private boolean stackHasSameNode(Stack<Node<T>> stack) {
        HashSet<Node> set = new HashSet<Node>();
        for (Node node : stack) {
            set.add(node);
        }
        return set.size() < stack.size();
    }

    private Node<T> getNode(Node<T> node, T from) {
        if (node.getData().equals(from)) {
            return node;
        }
        for (Node<T> child : node.getNodes()) {
            Node<T> x = this.getNode(child, from);
            if (x == null) continue;
            return x;
        }
        return null;
    }

    static class Node<T> {
        private T _data;
        private Set<Node<T>> _nodes = new HashSet<Node<T>>();

        Node() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this._data, node._data);
        }

        public int hashCode() {
            return Objects.hash(this._data);
        }

        public String toString() {
            return "Node{_data=" + this._data + ", _nodes=" + this._nodes + '}';
        }

        public T getData() {
            return this._data;
        }

        public Set<Node<T>> getNodes() {
            return this._nodes;
        }

        public void setData(T _data) {
            this._data = _data;
        }

        public void setNodes(Set<Node<T>> _nodes) {
            this._nodes = _nodes;
        }
    }
}

