/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.impl;

import cn.willingxyz.restdoc.core.parse.ITypeNameParser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeNameParser
implements ITypeNameParser {
    private Map<String, Type> _typeNameToType = new HashMap<String, Type>();

    @Override
    public String parse(Type type) {
        ArrayList<String> items = new ArrayList<String>();
        this.splitTypeName(type.getTypeName(), items);
        StringBuilder builder = new StringBuilder();
        for (String item : items) {
            item = this.simpleName(item);
            builder.append(item);
        }
        String simpledName = builder.toString();
        return this.selectName(type, items, simpledName, 1);
    }

    private String selectName(Type type, List<String> items, String typeName, int count) {
        if (!this._typeNameToType.containsKey(typeName)) {
            this._typeNameToType.put(typeName, type);
            return typeName;
        }
        if (this._typeNameToType.get(typeName).equals(type)) {
            return typeName;
        }
        String complexName = this.complexName(items, count);
        return this.selectName(type, items, complexName, count++);
    }

    private String complexName(List<String> items, int complexity) {
        int extraClassCount = items.stream().filter(o -> !o.startsWith("java.") && !o.startsWith("javax.")).mapToInt(o -> this.getDotCount((String)o)).sum();
        int javaCount = 0;
        int updateCount = 0;
        for (int i = 0; i < items.size(); ++i) {
            SimpleResult simpleResult;
            String item = items.get(i);
            if ((item.startsWith("java.") || item.startsWith("javax.")) && javaCount < complexity - extraClassCount) {
                simpleResult = this.simpleName(item, complexity);
                items.set(i, simpleResult.getResult());
                updateCount += simpleResult.getConsumeComplexity();
                javaCount += simpleResult.getConsumeComplexity();
                continue;
            }
            if (updateCount < complexity) {
                simpleResult = this.simpleName(item, complexity);
                items.set(i, simpleResult.getResult());
                updateCount += simpleResult.getConsumeComplexity();
                continue;
            }
            items.set(i, this.simpleName(item));
        }
        StringBuilder builder = new StringBuilder();
        for (String item : items) {
            builder.append(item);
        }
        return builder.toString();
    }

    private SimpleResult simpleName(String name, int complexity) {
        SimpleResult simpleResult = new SimpleResult();
        int dotCount = this.getDotCount(name);
        if (dotCount < complexity) {
            simpleResult.setResult(name);
            simpleResult.setConsumeComplexity(dotCount);
            return simpleResult;
        }
        int index = this.indexOf(name, dotCount - complexity);
        String result = name.substring(index + 1);
        simpleResult.setResult(result);
        simpleResult.setConsumeComplexity(complexity);
        return simpleResult;
    }

    private int getDotCount(String name) {
        return name.length() - name.replaceAll("\\.", "").length();
    }

    private int indexOf(String str, int count) {
        int currentCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '.' || ++currentCount != count) continue;
            return i;
        }
        return str.length() - 1;
    }

    private String simpleName(String item) {
        int index = item.lastIndexOf(".");
        return item.substring(index + 1);
    }

    private void splitTypeName(String typeName, List<String> items) {
        int leftAngleBracketIndex = typeName.indexOf(60);
        int rightAngleBracketIndex = typeName.lastIndexOf(62);
        if (leftAngleBracketIndex == -1 || rightAngleBracketIndex == -1) {
            this.addItem(items, typeName);
            return;
        }
        String rawType = typeName.substring(0, leftAngleBracketIndex);
        this.addItem(items, rawType);
        items.add("<");
        String typeArgument = typeName.substring(leftAngleBracketIndex + 1, rightAngleBracketIndex);
        this.splitTypeName(typeArgument, items);
        items.add(">");
    }

    private void addItem(List<String> items, String typeName) {
        int index = typeName.indexOf(44);
        if (index == -1) {
            items.add(typeName);
            return;
        }
        String[] types = typeName.split(",");
        for (int i = 0; i < types.length; ++i) {
            items.add(types[i]);
            if (i == types.length - 1) continue;
            items.add(",");
        }
    }

    public static class SimpleResult {
        private String _result;
        private int _consumeComplexity;

        public String getResult() {
            return this._result;
        }

        public int getConsumeComplexity() {
            return this._consumeComplexity;
        }

        public void setResult(String _result) {
            this._result = _result;
        }

        public void setConsumeComplexity(int _consumeComplexity) {
            this._consumeComplexity = _consumeComplexity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleResult)) {
                return false;
            }
            SimpleResult other = (SimpleResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$_result = this.getResult();
            String other$_result = other.getResult();
            if (this$_result == null ? other$_result != null : !this$_result.equals(other$_result)) {
                return false;
            }
            return this.getConsumeComplexity() == other.getConsumeComplexity();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SimpleResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $_result = this.getResult();
            result = result * 59 + ($_result == null ? 43 : $_result.hashCode());
            result = result * 59 + this.getConsumeComplexity();
            return result;
        }

        public String toString() {
            return "TypeNameParser.SimpleResult(_result=" + this.getResult() + ", _consumeComplexity=" + this.getConsumeComplexity() + ")";
        }
    }
}

