/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.impl;

import cn.willingxyz.restdoc.core.parse.ITypeInspector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class JavaTypeInspector
implements ITypeInspector {
    private List<Class> _simpleClass = new ArrayList<Class>(){
        {
            this.add(Boolean.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Double.class);
            this.add(Float.class);
            this.add(Character.class);
            this.add(CharSequence.class);
            this.add(Enum.class);
            this.add(Number.class);
            this.add(URI.class);
            this.add(URL.class);
            this.add(Locale.class);
            this.add(Date.class);
            this.add(LocalDateTime.class);
            this.add(LocalDate.class);
            this.add(LocalTime.class);
            this.add(Year.class);
            this.add(YearMonth.class);
            this.add(MonthDay.class);
            this.add(Instant.class);
        }
    };

    @Override
    public boolean isSimpleType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            for (Class simpleClass : this._simpleClass) {
                if (!simpleClass.isAssignableFrom(clazz)) continue;
                return true;
            }
            if (clazz.isPrimitive()) {
                return true;
            }
        } else if (type instanceof ParameterizedType) {
            return this.isSimpleType(((ParameterizedType)type).getRawType());
        }
        return false;
    }

    @Override
    public boolean isCollection(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return true;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return true;
            }
        } else if (type instanceof ParameterizedType) {
            return this.isCollection(((ParameterizedType)type).getRawType());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Type getCollectionComponentType(Type type) {
        if (!this.isCollection(type)) {
            throw new RuntimeException(type.getTypeName() + " is not collection");
        }
        if (!(type instanceof Class)) {
            if (!(type instanceof ParameterizedType)) return Object.class;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!Collection.class.isAssignableFrom((Class)parameterizedType.getRawType())) return Object.class;
            return parameterizedType.getActualTypeArguments()[0];
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (!Collection.class.isAssignableFrom(clazz)) return Object.class;
        return Object.class;
    }

    @Override
    public boolean isSupport(Type type) {
        return true;
    }
}

