/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.core.parse.impl;

import cn.willingxyz.restdoc.core.models.ParameterModel;
import cn.willingxyz.restdoc.core.parse.IMethodParameterParser;
import cn.willingxyz.restdoc.core.parse.RestDocParseConfig;
import cn.willingxyz.restdoc.core.parse.utils.FormatUtils;
import cn.willingxyz.restdoc.core.parse.utils.TypeParseUtils;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Optional;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public abstract class AbstractMethodParameterParser
implements IMethodParameterParser {
    protected final RestDocParseConfig _configuration;

    public AbstractMethodParameterParser(RestDocParseConfig configuration) {
        this._configuration = configuration;
    }

    @Override
    public ParameterModel parse(Parameter parameter, ParamJavadoc paramJavadoc, ParameterModel parameterModel) {
        parameterModel.setName(this.getParameterName(parameter));
        if (paramJavadoc != null) {
            parameterModel.setDescription(FormatUtils.format(paramJavadoc.getComment()));
        }
        Type actualParamType = parameter.getParameterizedType();
        if (parameter.getType() == Optional.class) {
            if (parameter.getParameterizedType() instanceof ParameterizedTypeImpl) {
                actualParamType = ((ParameterizedTypeImpl)parameter.getParameterizedType()).getActualTypeArguments()[0];
            } else {
                throw new RuntimeException("why?");
            }
        }
        parameterModel.setParameterType(actualParamType);
        parameterModel.setLocation(this.getParameterLocation(parameter, actualParamType));
        parameterModel = this.parseInternal(parameter, actualParamType, parameterModel);
        parameterModel.setRequired(this.isRequired(parameter, actualParamType));
        if (actualParamType != parameter.getParameterizedType()) {
            parameterModel.setRequired(false);
        }
        return parameterModel;
    }

    protected String getParameterName(Parameter parameter) {
        return parameter.getName();
    }

    protected abstract ParameterModel.ParameterLocation getParameterLocation(Parameter var1, Type var2);

    protected abstract boolean isRequired(Parameter var1, Type var2);

    protected ParameterModel parseInternal(Parameter parameter, Type actualParamType, ParameterModel parameterModel) {
        boolean isArray = this._configuration.getTypeInspector().isCollection(actualParamType);
        parameterModel.setArray(isArray);
        if (!isArray) {
            parameterModel.setChildren(TypeParseUtils.parseTypeProperty(this._configuration, actualParamType));
        } else {
            parameterModel.setChildren(TypeParseUtils.parseTypeProperty(this._configuration, this._configuration.getTypeInspector().getCollectionComponentType(actualParamType)));
        }
        return parameterModel;
    }
}

