/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.beanvalidation;

import cn.willingxyz.restdoc.core.models.PropertyItem;
import cn.willingxyz.restdoc.core.models.PropertyModel;
import cn.willingxyz.restdoc.core.models.TypeContext;
import cn.willingxyz.restdoc.core.parse.postprocessor.IPropertyPostProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.validation.Valid;

public abstract class AbstractBeanValidationPropertyPostProcessor<T extends Annotation>
implements IPropertyPostProcessor {
    public PropertyModel postProcess(PropertyModel propertyModel, TypeContext typeContext) {
        if (!this.cascadeValid(propertyModel, typeContext)) {
            return propertyModel;
        }
        return this.postProcessInternal(propertyModel);
    }

    private boolean cascadeValid(PropertyModel propertyModel, TypeContext typeContext) {
        Class clazz;
        AnnotatedParameterizedType annotatedParameterizedType;
        PropertyItem parent = propertyModel.getParentPropertyItem();
        if (parent == null) {
            return true;
        }
        Valid validAnno = (Valid)parent.getAnnotation(Valid.class);
        if (validAnno != null) {
            return true;
        }
        AnnotatedType annotatedType = null;
        if (parent.getField() != null) {
            annotatedType = parent.getField().getAnnotatedType();
        } else if (parent.getGetMethod() != null) {
            annotatedType = parent.getGetMethod().getAnnotatedReturnType();
        } else if (parent.getSetMethod() != null) {
            annotatedType = parent.getGetMethod().getAnnotatedParameterTypes()[0];
        }
        return annotatedType != null && annotatedType instanceof AnnotatedParameterizedType && (annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType).getType() instanceof ParameterizedType && List.class.isAssignableFrom(clazz = (Class)((ParameterizedType)annotatedParameterizedType.getType()).getRawType()) && annotatedParameterizedType.getAnnotatedActualTypeArguments()[0].getAnnotation(Valid.class) != null;
    }

    protected abstract PropertyModel postProcessInternal(PropertyModel var1);
}

