/*
 * Decompiled with CFR 0.152.
 */
package cn.wi4j.security.core.config;

import cn.wic4j.common.code.CommonCode;
import cn.wic4j.common.exception.BizException;
import cn.wic4j.common.result.Result;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="wic4j.security")
public class SecurityProperties
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SecurityProperties.class);
    private String customLoginPage;
    private List<String> ignoreUrls;

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasText((String)this.customLoginPage)) {
            log.error("\u672a\u914d\u7f6e\u7edf\u4e00\u767b\u5f55\u7684\u767b\u5f55\u5730\u5740,\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25");
            throw new BizException((Result)CommonCode.ERROR);
        }
        if (!this.ignoreUrls.contains("/favicon.ico")) {
            this.ignoreUrls.add("/favicon.ico");
        }
    }

    public String getCustomLoginPage() {
        return this.customLoginPage;
    }

    public List<String> getIgnoreUrls() {
        return this.ignoreUrls;
    }

    public void setCustomLoginPage(String customLoginPage) {
        this.customLoginPage = customLoginPage;
    }

    public void setIgnoreUrls(List<String> ignoreUrls) {
        this.ignoreUrls = ignoreUrls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityProperties)) {
            return false;
        }
        SecurityProperties other = (SecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$customLoginPage = this.getCustomLoginPage();
        String other$customLoginPage = other.getCustomLoginPage();
        if (this$customLoginPage == null ? other$customLoginPage != null : !this$customLoginPage.equals(other$customLoginPage)) {
            return false;
        }
        List<String> this$ignoreUrls = this.getIgnoreUrls();
        List<String> other$ignoreUrls = other.getIgnoreUrls();
        return !(this$ignoreUrls == null ? other$ignoreUrls != null : !((Object)this$ignoreUrls).equals(other$ignoreUrls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $customLoginPage = this.getCustomLoginPage();
        result = result * 59 + ($customLoginPage == null ? 43 : $customLoginPage.hashCode());
        List<String> $ignoreUrls = this.getIgnoreUrls();
        result = result * 59 + ($ignoreUrls == null ? 43 : ((Object)$ignoreUrls).hashCode());
        return result;
    }

    public String toString() {
        return "SecurityProperties(customLoginPage=" + this.getCustomLoginPage() + ", ignoreUrls=" + this.getIgnoreUrls() + ")";
    }
}

