/*
 * Decompiled with CFR 0.152.
 */
package cn.wi4j.security.core.code;

import cn.wic4j.common.result.Result;

public enum SecurityCode implements Result
{
    USERNAME_OR_PASSWORD_ERROR("WIC4J-01-00000", false, "username or password error"),
    ACCESS_TOKEN_INVALID("WIC4J-01-00001", false, "access token invalid"),
    REFRESH_TOKEN_INVALID("WIC4J-01-00002", false, "refresh token invalid"),
    GENERATOR_ACCESS_TOKEN_ERROR("WIC4J-01-00003", false, "generator access token error"),
    GENERATOR_REFRESH_TOKEN_ERROR("WIC4J-01-00004", false, "generator refresh token error"),
    CLIENT_INVALID("WIC4J-01-00005", false, "client invalid"),
    CLIENT_EXISTS("WIC4J-01-00006", false, "client exists"),
    CLIENT_NOT_EXISTS("WIC4J-01-00007", false, "client not exists"),
    INVALID_REQUEST_PARAMS_CHECKED_FAIL("WIC4J-01-00008", false, "params checked fail"),
    INVALID_SCOPE("WIC4J-01-00010", false, "invalid scope"),
    AUTHENTICATION_FAIL("WIC4J-01-00011", false, "authentication fail");

    private final String code;
    private final boolean success;
    private final String message;

    public static SecurityCode getSecurityCodeByCode(String code) {
        for (SecurityCode value : SecurityCode.values()) {
            if (!value.code.equals(code)) continue;
            return value;
        }
        return null;
    }

    public String code() {
        return this.code;
    }

    public boolean success() {
        return this.success;
    }

    public String message() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    private SecurityCode(String code, boolean success, String message) {
        this.code = code;
        this.success = success;
        this.message = message;
    }
}

