/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
package cn.wi4j.security.core.utils;

import com.alibaba.fastjson2.JSON;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.http.MediaType;

import java.io.IOException;

/**
 * 响应工具类<br>
 *
 * @author Max
 * @version 2023.0.0.0
 * @since 2023/7/11 21:06
 */
public class ResponseUtils {
    /**
     * 调用者响应200状态码的JSON数据
     *
     * @param response response
     * @param data     响应数据
     * @param <R>      响应数据的泛型
     * @throws IOException IOException
     */
    public static <R> void responseUtf8(HttpServletResponse response, R data) throws IOException {
        if (null != data) {
            response.setStatus(200);
            response.setCharacterEncoding("UTF-8");
            response.setContentType(MediaType.APPLICATION_JSON_VALUE);
            response.getWriter().println(JSON.toJSONString(data));
            response.getWriter().flush();
        }
    }
}
