/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
package cn.wi4j.security.core.config;

import cn.wic4j.common.code.CommonCode;
import cn.wic4j.common.exception.BizException;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 配置文件<br>
 *
 * @author Max
 * @version 2023.0.0.0
 * @since 2023/7/11 19:37
 */
@Data
@Slf4j
@ConfigurationProperties(prefix = "wic4j.security")
public class SecurityProperties implements InitializingBean {

    /**
     * 自定义登录页面
     */
    private String customLoginPage;


    /**
     * 忽略的请求URL,即不需要登录即可访问的地址
     */
    private List<String> ignoreUrls;

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties
     * and satisfied {@link BeanFactoryAware}, {@code ApplicationContextAware} etc.
     * <p>This method allows the bean instance to perform validation of its overall
     * configuration and final initialization when all bean properties have been set.
     *
     * @throws Exception in the event of misconfiguration (such as failure to set an
     *                   essential property) or if initialization fails for any other reason
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasText(customLoginPage)) {
            log.error("未配置统一登录的登录地址,服务器启动失败");
            throw new BizException(CommonCode.ERROR);
        }
        if (!ignoreUrls.contains("/favicon.ico")) {
            ignoreUrls.add("/favicon.ico");
        }
    }
}
