/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
package cn.wi4j.security.core.code;

import cn.wic4j.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 安全code<br>
 *
 * @author Max
 * @version 2023.0.0.0
 * @since 2023/7/12 21:46
 */
@Getter
@AllArgsConstructor
public enum SecurityCode implements Result {
    /**
     * 用户名或者密码错误
     */
    USERNAME_OR_PASSWORD("WIC4J-01-00000", false, "username or password error");;


    /**
     * 根据状态码获取枚举
     *
     * @param code code
     * @return 安全相关枚举
     */
    public static SecurityCode getSecurityCodeByCode(String code) {
        for (SecurityCode value : SecurityCode.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }

    /**
     * 自定义状态码
     */
    private final String code;
    /**
     * 是否操作成功
     */
    private final boolean success;
    /**
     * 自定义提示信息
     */
    private final String message;


    /**
     * 返回自定义状态码
     *
     * @return 自定义业务状态码
     */
    @Override
    public String code() {
        return this.code;
    }

    /**
     * 返回是否操作成功
     *
     * @return 返回是否操作成功
     */
    @Override
    public boolean success() {
        return this.success;
    }

    /**
     * 返回自定义提示信息
     *
     * @return 自定义提示信息
     */
    @Override
    public String message() {
        return this.message;
    }
}
