/*
 * Decompiled with CFR 0.152.
 */
package cn.wensiqun.asmsupport.sample.client.json.utils;

public class StringEncoder {
    private StringBuilder stringBuilder;

    public StringEncoder() {
        this.stringBuilder = new StringBuilder();
    }

    public StringEncoder(int capacity) {
        this.stringBuilder = new StringBuilder(capacity);
    }

    public int length() {
        return this.stringBuilder.length();
    }

    public StringEncoder append(CharSequence csq) {
        if (csq == null) {
            this.stringBuilder.ensureCapacity(this.stringBuilder.length());
            this.stringBuilder.append("null");
        } else {
            this.stringBuilder.ensureCapacity(this.stringBuilder.length() + csq.length());
            int len = csq.length();
            for (int i = 0; i < len; ++i) {
                this.append(csq.charAt(i));
            }
        }
        return this;
    }

    public StringEncoder append(char c) {
        if (c == '\\') {
            this.stringBuilder.append('\\').append('\\');
        } else if (c == '\"') {
            this.stringBuilder.append('\\').append('\"');
        } else {
            this.stringBuilder.append(c);
        }
        return this;
    }

    public StringEncoder appendDirect(char c) {
        this.stringBuilder.append(c);
        return this;
    }

    public StringEncoder append(boolean c) {
        this.stringBuilder.append(c);
        return this;
    }

    public StringEncoder append(byte c) {
        this.stringBuilder.append(c);
        return this;
    }

    public StringEncoder append(short c) {
        this.stringBuilder.append(c);
        return this;
    }

    public StringEncoder append(int c) {
        this.stringBuilder.append(c);
        return this;
    }

    public StringEncoder append(float c) {
        this.stringBuilder.append(c);
        return this;
    }

    public StringEncoder append(long c) {
        this.stringBuilder.append(c);
        return this;
    }

    public StringEncoder append(double c) {
        this.stringBuilder.append(c);
        return this;
    }

    public StringEncoder append(Object c) {
        return this.append(c.toString());
    }

    public StringEncoder trimLastComma() {
        int len = this.stringBuilder.length() - 1;
        if (',' == this.stringBuilder.charAt(len)) {
            this.stringBuilder.deleteCharAt(len);
        }
        return this;
    }

    public StringEncoder deleteCharAt(int index) {
        this.stringBuilder.deleteCharAt(index);
        return this;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

