/*
 * Decompiled with CFR 0.152.
 */
package cn.wensiqun.asmsupport.sample.client.json;

import cn.wensiqun.asmsupport.client.DummyClass;
import cn.wensiqun.asmsupport.client.DummyConstructor;
import cn.wensiqun.asmsupport.client.DummyMethod;
import cn.wensiqun.asmsupport.client.block.ConstructorBody;
import cn.wensiqun.asmsupport.client.block.IF;
import cn.wensiqun.asmsupport.client.block.MethodBody;
import cn.wensiqun.asmsupport.client.block.ProgramBlock;
import cn.wensiqun.asmsupport.client.def.Param;
import cn.wensiqun.asmsupport.client.def.param.UncertainParam;
import cn.wensiqun.asmsupport.client.def.var.LocVar;
import cn.wensiqun.asmsupport.core.block.KernelProgramBlock;
import cn.wensiqun.asmsupport.core.utils.reflect.ModifierUtils;
import cn.wensiqun.asmsupport.sample.client.json.generator.IValueGeneratorChain;
import cn.wensiqun.asmsupport.sample.client.json.generator.impl.ArrayGeneratorChain;
import cn.wensiqun.asmsupport.sample.client.json.generator.impl.BaseGeneratorChain;
import cn.wensiqun.asmsupport.sample.client.json.generator.impl.BeanGeneratorChain;
import cn.wensiqun.asmsupport.sample.client.json.generator.impl.IterableGeneratorChain;
import cn.wensiqun.asmsupport.sample.client.json.generator.impl.MapGeneratorChain;
import cn.wensiqun.asmsupport.sample.client.json.parser.AbstractParser;
import cn.wensiqun.asmsupport.sample.client.json.parser.ArrayParser;
import cn.wensiqun.asmsupport.sample.client.json.parser.BaseParser;
import cn.wensiqun.asmsupport.sample.client.json.parser.CharSequenceParser;
import cn.wensiqun.asmsupport.sample.client.json.parser.IterableParser;
import cn.wensiqun.asmsupport.sample.client.json.parser.MapParser;
import cn.wensiqun.asmsupport.sample.client.json.utils.ReflectionUtils;
import cn.wensiqun.asmsupport.sample.client.json.utils.StringEncoder;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JSONPool {
    private ConcurrentMap<Class<?>, AbstractParser> parserMap;
    private AbstractParser arrayParser = new ArrayParser(this);
    private IValueGeneratorChain header;

    public JSONPool() {
        this.parserMap = new ConcurrentHashMap();
        AbstractParser parser = new BaseParser(this);
        this.parserMap.put(Boolean.TYPE, parser);
        this.parserMap.put(Boolean.class, parser);
        this.parserMap.put(Byte.TYPE, parser);
        this.parserMap.put(Byte.class, parser);
        this.parserMap.put(Short.TYPE, parser);
        this.parserMap.put(Short.class, parser);
        this.parserMap.put(Integer.TYPE, parser);
        this.parserMap.put(Integer.class, parser);
        this.parserMap.put(Float.TYPE, parser);
        this.parserMap.put(Float.class, parser);
        this.parserMap.put(Long.TYPE, parser);
        this.parserMap.put(Long.class, parser);
        this.parserMap.put(Double.TYPE, parser);
        this.parserMap.put(Double.class, parser);
        parser = new CharSequenceParser(this);
        this.parserMap.put(Character.TYPE, parser);
        this.parserMap.put(Character.class, parser);
        this.parserMap.put(String.class, parser);
        parser = new MapParser(this);
        this.parserMap.put(Map.class, parser);
        parser = new IterableParser(this);
        this.parserMap.put(Iterable.class, parser);
        this.header = new BaseGeneratorChain();
        this.header.setNext(new ArrayGeneratorChain()).setNext(new MapGeneratorChain()).setNext(new IterableGeneratorChain()).setNext(new BeanGeneratorChain());
    }

    public AbstractParser register(Class<?> type, AbstractParser parser) {
        return this.parserMap.putIfAbsent(type, parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractParser getOrRegister(Class<?> type) {
        AbstractParser parser = (AbstractParser)this.parserMap.get(type);
        if (parser == null) {
            ConcurrentMap<Class<?>, AbstractParser> concurrentMap = this.parserMap;
            synchronized (concurrentMap) {
                parser = (AbstractParser)this.parserMap.get(type);
                if (parser == null) {
                    try {
                        Class<?> target = this.buildClass(new IValueGeneratorChain.GeneratorContext(this, this.header), type);
                        parser = (AbstractParser)target.getConstructor(JSONPool.class).newInstance(this);
                        this.parserMap.put(type, parser);
                    }
                    catch (Exception e) {
                        System.out.println("Error build parser class : " + type + " cause by " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        return parser;
    }

    public String getJson(Object val) {
        if (val == null) {
            return "null";
        }
        Class<?> type = val.getClass();
        if (type.isArray()) {
            return this.arrayParser.parse(val);
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return this.getOrRegister(Iterable.class).parse(val);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.getOrRegister(Map.class).parse(val);
        }
        return this.getOrRegister(type).parse(val);
    }

    public void getJson(StringEncoder encoder, Object val) {
        if (val == null) {
            encoder.append("null");
        }
        Class<?> type = val.getClass();
        this.getOrRegister(type).parse(encoder, val);
    }

    private Class<?> buildClass(final IValueGeneratorChain.GeneratorContext context, final Class<?> type) {
        DummyClass dummy = ((DummyClass)new DummyClass(type.getName() + "Parser").public_()).extends_(AbstractParser.class).setClassOutPutPath(".//target//asmsupport-test-generated");
        ((DummyConstructor)dummy.newConstructor().public_()).argTypes(new Class[]{JSONPool.class}).body(new ConstructorBody(){

            public void body(LocVar ... args) {
                this.supercall((Param[])args);
                this.return_();
            }
        });
        ((DummyMethod)dummy.newMethod("parse").public_()).argTypes(new Class[]{StringEncoder.class, Object.class}).argNames(new String[]{"encoder", "object"}).body(new MethodBody(){

            public void body(LocVar ... args) {
                Field[] fields;
                final LocVar encoder = args[0];
                LocVar val = this.var(type, (Param)this.checkcast((Param)args[1], type));
                encoder.call("append", new Param[]{this.val(Character.valueOf('{'))});
                for (Field f : fields = type.getDeclaredFields()) {
                    final String name = f.getName();
                    final Class<?> fieldType = f.getType();
                    if (ModifierUtils.isStatic((int)f.getModifiers())) {
                        System.out.println("Warning : field '" + name + "' is static, pass it.");
                        continue;
                    }
                    String getterStr = JSONPool.this.getGetter(fieldType, name);
                    try {
                        type.getMethod(getterStr, new Class[0]);
                    }
                    catch (SecurityException e) {
                        System.out.println("Warning : error parse field '" + name + "' , pass it, cause by " + e.getMessage());
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        System.out.println("Warning : not found getter method of field '" + name + "', pass it.");
                        continue;
                    }
                    final UncertainParam getterCall = val.call(getterStr, new Param[0]);
                    if (fieldType.isPrimitive()) {
                        if (name.matches("^[A-Za-z][_A-Za-z0-9]*$")) {
                            encoder.call("append", new Param[]{this.val(name + ":")});
                        } else {
                            encoder.call("appendDirect", new Param[]{this.val(Character.valueOf('\"'))});
                            encoder.call("append", new Param[]{this.val(name)});
                            encoder.call("appendDirect", new Param[]{this.val(Character.valueOf('\"'))});
                            encoder.call("appendDirect", new Param[]{this.val(Character.valueOf(':'))});
                        }
                        encoder.call("append", new Param[]{getterCall});
                        encoder.call("appendDirect", new Param[]{this.val(Character.valueOf(','))});
                        continue;
                    }
                    this.if_(new IF((Param)getterCall.ne((Param)this.null_(Object.class))){

                        public void body() {
                            if (name.matches("^[A-Za-z][_A-Za-z0-9]*$")) {
                                encoder.call("append", new Param[]{this.val(name + ":")});
                            } else {
                                encoder.call("appendDirect", new Param[]{this.val(Character.valueOf('\"'))});
                                encoder.call("append", new Param[]{this.val(name)});
                                encoder.call("appendDirect", new Param[]{this.val(Character.valueOf('\"'))});
                                encoder.call("appendDirect", new Param[]{this.val(Character.valueOf(':'))});
                            }
                            JSONPool.this.header.generate(context, (ProgramBlock<? extends KernelProgramBlock>)this, encoder, this.getType(fieldType), (Param)getterCall);
                            encoder.call("appendDirect", new Param[]{this.val(Character.valueOf(','))});
                        }
                    });
                }
                encoder.call("trimLastComma", new Param[0]);
                encoder.call("append", new Param[]{this.val(Character.valueOf('}'))});
                this.return_();
            }
        });
        return dummy.build();
    }

    private String getGetter(Class<?> type, String name) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ReflectionUtils.getIsGetter(name);
        }
        return ReflectionUtils.getGetter(name);
    }
}

