/*
 * Decompiled with CFR 0.152.
 */
package cn.wensiqun.asmsupport.client;

import cn.wensiqun.asmsupport.client.DummyConstructor;
import cn.wensiqun.asmsupport.client.DummyField;
import cn.wensiqun.asmsupport.client.DummyMethod;
import cn.wensiqun.asmsupport.client.DummyModifiedMethod;
import cn.wensiqun.asmsupport.client.block.BlockPostern;
import cn.wensiqun.asmsupport.client.block.ModifiedMethodBody;
import cn.wensiqun.asmsupport.client.block.StaticBlockBody;
import cn.wensiqun.asmsupport.core.block.method.clinit.KernelStaticBlockBody;
import cn.wensiqun.asmsupport.core.block.method.common.KernelMethodBody;
import cn.wensiqun.asmsupport.core.block.method.common.KernelModifiedMethodBody;
import cn.wensiqun.asmsupport.core.block.method.init.KernelConstructorBody;
import cn.wensiqun.asmsupport.core.creator.clazz.ClassModifier;
import cn.wensiqun.asmsupport.core.log.LogFactory;
import cn.wensiqun.asmsupport.core.utils.ASConstant;
import cn.wensiqun.asmsupport.core.utils.lang.StringUtils;
import cn.wensiqun.asmsupport.standard.error.ASMSupportException;
import java.util.LinkedList;

public class DummyModifiedClass {
    private Class<?> original;
    private ClassLoader classLoader;
    private String classOutPutPath;
    private boolean printLog;
    private String logFilePath;
    private LinkedList<DummyConstructor> constructorDummies = new LinkedList();
    private LinkedList<DummyField> fieldDummies = new LinkedList();
    private LinkedList<DummyMethod> methodDummies = new LinkedList();
    private StaticBlockBody staticBlock;
    private LinkedList<DummyModifiedMethod> modifyDummies = new LinkedList();

    public DummyModifiedClass(Class<?> original) {
        this.original = original;
    }

    public DummyModifiedClass setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DummyModifiedClass setClassOutPutPath(String path) {
        this.classOutPutPath = path;
        return this;
    }

    public String getClassOutPutPath() {
        return this.classOutPutPath;
    }

    public DummyModifiedClass setPrintLog(boolean print) {
        this.printLog = print;
        return this;
    }

    public DummyModifiedClass setLogFilePath(String logFile) {
        this.logFilePath = logFile;
        this.printLog = true;
        return this;
    }

    public DummyField newField() {
        this.fieldDummies.add(new DummyField());
        return this.fieldDummies.getLast();
    }

    public DummyConstructor newConstructor() {
        this.constructorDummies.add(new DummyConstructor());
        return this.constructorDummies.getLast();
    }

    public DummyMethod newMethod(String name) {
        DummyMethod method = new DummyMethod();
        method.name(name);
        this.methodDummies.add(method);
        return method;
    }

    public DummyModifiedClass newStaticBlock(StaticBlockBody staticBlock) {
        if (staticBlock != null) {
            throw new ASMSupportException("Static Block is already existes.");
        }
        this.staticBlock = staticBlock;
        return this;
    }

    public DummyModifiedClass modify(String method, Class<?>[] argTypes, ModifiedMethodBody body) {
        DummyModifiedMethod dmm = new DummyModifiedMethod(method, argTypes, body);
        this.modifyDummies.add(dmm);
        return this;
    }

    public DummyModifiedClass modifyConstructor(Class<?>[] argTypes, ModifiedMethodBody body) {
        return this.modify("<init>", argTypes, body);
    }

    public DummyModifiedClass modifyStaticBlock(ModifiedMethodBody body) {
        return this.modify("<clinit>", null, body);
    }

    public Class<?> build() {
        ASConstant.LOG_FACTORY_LOCAL.remove();
        if (StringUtils.isNotBlank((CharSequence)this.logFilePath)) {
            ASConstant.LOG_FACTORY_LOCAL.set(new LogFactory(this.logFilePath));
        } else if (this.printLog) {
            ASConstant.LOG_FACTORY_LOCAL.set(new LogFactory());
        }
        ClassModifier cmi = new ClassModifier(this.original);
        for (DummyConstructor dummyConstructor : this.constructorDummies) {
            if (dummyConstructor.getConstructorBody() != null) {
                cmi.createConstructor(dummyConstructor.getModifiers(), dummyConstructor.getArgumentTypes(), dummyConstructor.getArgumentNames(), dummyConstructor.getThrows(), (KernelConstructorBody)BlockPostern.getTarget(dummyConstructor.getConstructorBody()));
                continue;
            }
            throw new ASMSupportException("Not found body...");
        }
        for (DummyField dummyField : this.fieldDummies) {
            if (dummyField.getType() == null) {
                throw new ASMSupportException("Not specify field type for field '" + dummyField.getName() + "'");
            }
            if (dummyField.getName() == null) {
                throw new ASMSupportException("Not specify field name.");
            }
            cmi.createField(dummyField.getName(), dummyField.getModifiers(), dummyField.getType(), dummyField.getValue());
        }
        for (DummyMethod dummyMethod : this.methodDummies) {
            cmi.createMethodForDummy(dummyMethod.getModifiers(), dummyMethod.getName(), dummyMethod.getArgTypes(), dummyMethod.getArgNames(), dummyMethod.getReturnType(), dummyMethod.getThrows(), (KernelMethodBody)BlockPostern.getTarget(dummyMethod.getMethodBody()));
        }
        if (this.staticBlock != null) {
            cmi.createStaticBlock((KernelStaticBlockBody)BlockPostern.getTarget(this.staticBlock));
        }
        for (DummyModifiedMethod dummyModifiedMethod : this.modifyDummies) {
            cmi.modifyMethod(dummyModifiedMethod.getName(), (Class[])dummyModifiedMethod.getArgumentTypes(), (KernelModifiedMethodBody)BlockPostern.getTarget(dummyModifiedMethod.getMethodBody()));
        }
        cmi.setParentClassLoader(this.classLoader);
        cmi.setClassOutPutPath(this.classOutPutPath);
        return cmi.startup();
    }
}

