/*
 * Decompiled with CFR 0.152.
 */
package cn.wensiqun.asmsupport.client;

import cn.wensiqun.asmsupport.client.DummyField;
import cn.wensiqun.asmsupport.client.DummyInterfaceMethod;
import cn.wensiqun.asmsupport.client.block.BlockPostern;
import cn.wensiqun.asmsupport.client.block.StaticBlockBody;
import cn.wensiqun.asmsupport.core.block.method.clinit.KernelStaticBlockBody;
import cn.wensiqun.asmsupport.core.creator.clazz.InterfaceCreator;
import cn.wensiqun.asmsupport.core.log.LogFactory;
import cn.wensiqun.asmsupport.core.utils.ASConstant;
import cn.wensiqun.asmsupport.core.utils.CommonUtils;
import cn.wensiqun.asmsupport.core.utils.lang.StringUtils;
import cn.wensiqun.asmsupport.standard.def.clazz.AClass;
import cn.wensiqun.asmsupport.standard.error.ASMSupportException;
import java.util.LinkedList;

public class DummyInterface {
    private int javaVersion = CommonUtils.getSystemJDKVersion();
    private String packageName = "";
    private String name;
    private Class<?>[] interfaces;
    private ClassLoader classLoader;
    private String classOutPutPath;
    private boolean printLog;
    private String logFilePath;
    private LinkedList<DummyField> fieldDummies = new LinkedList();
    private LinkedList<DummyInterfaceMethod> methodDummies = new LinkedList();
    private StaticBlockBody staticBlock;
    protected int modifiers = 1024;

    public DummyInterface() {
    }

    public DummyInterface(String qualifiedName) {
        if (StringUtils.isNotBlank((CharSequence)qualifiedName)) {
            int lastDot = qualifiedName.lastIndexOf(46);
            if (lastDot > 0) {
                this.packageName = qualifiedName.substring(0, lastDot);
                this.name = qualifiedName.substring(lastDot + 1);
            } else {
                this.name = qualifiedName;
            }
        }
    }

    public DummyInterface(String pkgName, String name) {
        this.packageName = pkgName;
        this.name = name;
    }

    public DummyInterface public_() {
        this.modifiers = (this.modifiers & 0xFFFFFFFE) + 1;
        return this;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public DummyInterface default_() {
        this.modifiers &= 0xFFFFFFFE;
        return this;
    }

    public boolean isDefault() {
        return !this.isPublic();
    }

    public DummyInterface package_(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getPackage() {
        return this.packageName;
    }

    public DummyInterface name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DummyInterface setJavaVersion(int version) {
        this.javaVersion = version;
        return this;
    }

    public int getJavaVersion() {
        return this.javaVersion;
    }

    public DummyInterface extends_(Class<?> ... interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    public Class<?>[] getExtends() {
        if (this.interfaces == null) {
            return new Class[0];
        }
        Class[] copy = new Class[this.interfaces.length];
        System.arraycopy(this.interfaces, 0, copy, 0, copy.length);
        return copy;
    }

    public DummyInterface setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DummyInterface setClassOutPutPath(String path) {
        this.classOutPutPath = path;
        return this;
    }

    public String getClassOutPutPath() {
        return this.classOutPutPath;
    }

    public DummyInterface setPrintLog(boolean print) {
        this.printLog = print;
        return this;
    }

    public DummyInterface setLogFilePath(String logFile) {
        this.logFilePath = logFile;
        this.printLog = true;
        return this;
    }

    public DummyField newField(AClass type, String name) {
        DummyField field = new DummyField();
        this.fieldDummies.add(field);
        field.type(type).name(name);
        return field;
    }

    public DummyField newField(Class<?> type, String name) {
        DummyField field = new DummyField();
        this.fieldDummies.add(field);
        field.type(type).name(name);
        return field;
    }

    public DummyInterfaceMethod newMethod(String name) {
        DummyInterfaceMethod method = new DummyInterfaceMethod();
        method.name(name);
        this.methodDummies.add(method);
        return method;
    }

    public DummyInterface newStaticBlock(StaticBlockBody staticBlock) {
        if (this.staticBlock != null) {
            throw new ASMSupportException("Static Block is already existes.");
        }
        this.staticBlock = staticBlock;
        return this;
    }

    public Class<?> build() {
        ASConstant.LOG_FACTORY_LOCAL.remove();
        if (StringUtils.isNotBlank((CharSequence)this.logFilePath)) {
            ASConstant.LOG_FACTORY_LOCAL.set(new LogFactory(this.logFilePath));
        } else if (this.printLog) {
            ASConstant.LOG_FACTORY_LOCAL.set(new LogFactory());
        }
        InterfaceCreator ici = new InterfaceCreator(this.javaVersion, StringUtils.isBlank((CharSequence)this.packageName) ? this.name : this.packageName + "." + this.name, (Class[])this.interfaces);
        for (DummyField dummyField : this.fieldDummies) {
            if (dummyField.getType() == null) {
                throw new ASMSupportException("Not specify field type for field '" + dummyField.getName() + "'");
            }
            if (dummyField.getName() == null) {
                throw new ASMSupportException("Not specify field name.");
            }
            ici.createField(dummyField.getName(), dummyField.getType(), dummyField.getValue());
        }
        for (DummyInterfaceMethod dummyInterfaceMethod : this.methodDummies) {
            ici.createMethod(dummyInterfaceMethod.getName(), dummyInterfaceMethod.getArgTypes(), dummyInterfaceMethod.getReturnType(), dummyInterfaceMethod.getThrows(), dummyInterfaceMethod.isVarargs());
        }
        if (this.staticBlock != null) {
            ici.createStaticBlock((KernelStaticBlockBody)BlockPostern.getTarget(this.staticBlock));
        }
        ici.setParentClassLoader(this.classLoader);
        ici.setClassOutPutPath(this.classOutPutPath);
        return ici.startup();
    }
}

