/*
 * Decompiled with CFR 0.152.
 */
package cn.wensiqun.asmsupport.client;

import cn.wensiqun.asmsupport.client.DummyEnumConstructor;
import cn.wensiqun.asmsupport.client.DummyField;
import cn.wensiqun.asmsupport.client.DummyMethod;
import cn.wensiqun.asmsupport.client.block.BlockPostern;
import cn.wensiqun.asmsupport.client.block.EnumStaticBlockBody;
import cn.wensiqun.asmsupport.core.block.method.clinit.KernelEnumStaticBlockBody;
import cn.wensiqun.asmsupport.core.block.method.common.KernelMethodBody;
import cn.wensiqun.asmsupport.core.block.method.init.KernelEnumConstructorBody;
import cn.wensiqun.asmsupport.core.creator.clazz.EnumCreator;
import cn.wensiqun.asmsupport.core.log.LogFactory;
import cn.wensiqun.asmsupport.core.utils.ASConstant;
import cn.wensiqun.asmsupport.core.utils.CommonUtils;
import cn.wensiqun.asmsupport.core.utils.lang.StringUtils;
import cn.wensiqun.asmsupport.standard.def.clazz.AClass;
import cn.wensiqun.asmsupport.standard.error.ASMSupportException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class DummyEnum {
    private int javaVersion = CommonUtils.getSystemJDKVersion();
    private String packageName = "";
    private String name;
    private Class<?>[] interfaces;
    private Set<String> enums = new HashSet<String>();
    private LinkedList<DummyEnumConstructor> constructorDummies = new LinkedList();
    private EnumStaticBlockBody staticBlock;
    private LinkedList<DummyField> fieldDummies = new LinkedList();
    private LinkedList<DummyMethod> methodDummies = new LinkedList();
    private ClassLoader classLoader;
    private String classOutPutPath;
    private boolean printLog;
    private String logFilePath;

    public DummyEnum() {
    }

    public DummyEnum(String qualifiedName) {
        if (StringUtils.isNotBlank((CharSequence)qualifiedName)) {
            int lastDot = qualifiedName.lastIndexOf(46);
            if (lastDot > 0) {
                this.packageName = qualifiedName.substring(0, lastDot);
                this.name = qualifiedName.substring(lastDot + 1);
            } else {
                this.name = qualifiedName;
            }
        }
    }

    public DummyEnum(String pkgName, String name) {
        this.packageName = pkgName;
        this.name = name;
    }

    public DummyEnum setJavaVersion(int version) {
        this.javaVersion = version;
        return this;
    }

    public int getJavaVersion() {
        return this.javaVersion;
    }

    public DummyEnum package_(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getPackage() {
        return this.packageName;
    }

    public DummyEnum name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DummyEnum implements_(Class<?> ... interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    public DummyEnum setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DummyEnum setClassOutPutPath(String path) {
        this.classOutPutPath = path;
        return this;
    }

    public String getClassOutPutPath() {
        return this.classOutPutPath;
    }

    public DummyEnum setPrintLog(boolean print) {
        this.printLog = print;
        return this;
    }

    public DummyEnum setLogFilePath(String logFile) {
        this.logFilePath = logFile;
        this.printLog = true;
        return this;
    }

    public Class<?>[] getImplements() {
        if (this.interfaces == null) {
            return new Class[0];
        }
        Class[] copy = new Class[this.interfaces.length];
        System.arraycopy(this.interfaces, 0, copy, 0, copy.length);
        return copy;
    }

    public DummyEnum newEnum(String enumName) {
        if (this.enums.contains(enumName)) {
            throw new ASMSupportException("Then enum \"" + enumName + "\" type are duplicated declare.");
        }
        this.enums.add(enumName);
        return this;
    }

    public DummyEnumConstructor newConstructor() {
        this.constructorDummies.add(new DummyEnumConstructor());
        return this.constructorDummies.getLast();
    }

    public DummyEnum newStaticBlock(EnumStaticBlockBody staticBlock) {
        if (this.staticBlock != null) {
            throw new ASMSupportException("Static Block is already existes.");
        }
        this.staticBlock = staticBlock;
        return this;
    }

    public DummyField newField(AClass type, String name) {
        DummyField field = new DummyField();
        this.fieldDummies.add(field);
        field.type(type).name(name);
        return this.fieldDummies.getLast();
    }

    public DummyField newField(Class<?> type, String name) {
        DummyField field = new DummyField();
        this.fieldDummies.add(field);
        field.type(type).name(name);
        return this.fieldDummies.getLast();
    }

    public DummyMethod newMethod(String name) {
        DummyMethod method = new DummyMethod();
        this.methodDummies.add(method);
        method.name(name);
        return method;
    }

    public Class<?> build() {
        ASConstant.LOG_FACTORY_LOCAL.remove();
        if (StringUtils.isNotBlank((CharSequence)this.logFilePath)) {
            ASConstant.LOG_FACTORY_LOCAL.set(new LogFactory(this.logFilePath));
        } else if (this.printLog) {
            ASConstant.LOG_FACTORY_LOCAL.set(new LogFactory());
        }
        EnumCreator eci = new EnumCreator(this.javaVersion, StringUtils.isBlank((CharSequence)this.packageName) ? this.name : this.packageName + "." + this.name, (Class[])this.interfaces);
        for (DummyEnumConstructor dummyEnumConstructor : this.constructorDummies) {
            if (dummyEnumConstructor.getConstructorBody() != null) {
                eci.createConstructor(dummyEnumConstructor.getArgumentTypes(), dummyEnumConstructor.getArgumentNames(), (KernelEnumConstructorBody)BlockPostern.getTarget(dummyEnumConstructor.getConstructorBody()));
                continue;
            }
            throw new ASMSupportException("Not found body...");
        }
        for (String string : this.enums) {
            eci.createEnumConstant(string);
        }
        for (DummyField dummyField : this.fieldDummies) {
            if (dummyField.getType() == null) {
                throw new ASMSupportException("Not specify field type for field '" + dummyField.getName() + "'");
            }
            if (dummyField.getName() == null) {
                throw new ASMSupportException("Not specify field name.");
            }
            eci.createField(dummyField.getName(), dummyField.getModifiers(), dummyField.getType(), dummyField.getValue());
        }
        for (DummyMethod dummyMethod : this.methodDummies) {
            eci.createMethodForDummy(dummyMethod.getName(), dummyMethod.getArgTypes(), dummyMethod.getArgNames(), dummyMethod.getReturnType(), dummyMethod.getThrows(), dummyMethod.getModifiers(), (KernelMethodBody)BlockPostern.getTarget(dummyMethod.getMethodBody()));
        }
        if (this.staticBlock != null) {
            eci.createStaticBlock((KernelEnumStaticBlockBody)BlockPostern.getTarget(this.staticBlock));
        }
        eci.setParentClassLoader(this.classLoader);
        eci.setClassOutPutPath(this.classOutPutPath);
        return eci.startup();
    }
}

